/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.wand;

import hellfirepvp.astralsorcery.common.block.BlockFlareLight;
import hellfirepvp.astralsorcery.common.block.BlockTranslucentBlock;
import hellfirepvp.astralsorcery.common.constellation.charge.PlayerChargeHandler;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.item.base.render.ItemAlignmentChargeConsumer;
import hellfirepvp.astralsorcery.common.item.base.render.ItemAlignmentChargeRevealer;
import hellfirepvp.astralsorcery.common.item.base.render.ItemDynamicColor;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.tile.TileIlluminator;
import hellfirepvp.astralsorcery.common.tile.TileTranslucent;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemIlluminationWand
extends Item
implements ItemAlignmentChargeConsumer,
ItemDynamicColor {
    public ItemIlluminationWand() {
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77637_a(RegistryItems.creativeTabAstralSorcery);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        EnumDyeColor color = ItemIlluminationWand.getConfiguredColor(stack);
        if (color != null) {
            tooltip.add(MiscUtils.textFormattingForDye(color) + MiscUtils.capitalizeFirst(I18n.func_135052_a((String)color.func_176762_d(), (Object[])new Object[0])));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldReveal(ItemAlignmentChargeRevealer.ChargeType ct, ItemStack stack) {
        return ct == ItemAlignmentChargeRevealer.ChargeType.TEMP;
    }

    @Override
    public int getColorForItemStack(ItemStack stack, int tintIndex) {
        if (tintIndex != 1) {
            return 0xFFFFFF;
        }
        EnumDyeColor color = ItemIlluminationWand.getConfiguredColor(stack);
        if (color == null) {
            color = EnumDyeColor.YELLOW;
        }
        Color c = MiscUtils.flareColorFromDye(color);
        return 0xFF000000 | c.getRGB();
    }

    public static void setConfiguredColor(ItemStack stack, EnumDyeColor color) {
        NBTHelper.getPersistentData(stack).func_74768_a("color", color.func_176767_b());
    }

    @Nullable
    public static EnumDyeColor getConfiguredColor(ItemStack stack) {
        NBTTagCompound tag = NBTHelper.getPersistentData(stack);
        if (tag != null && tag.func_74764_b("color")) {
            return EnumDyeColor.func_176766_a((int)NBTHelper.getPersistentData(stack).func_74762_e("color"));
        }
        return null;
    }

    public static IBlockState getPlacingState(ItemStack wand) {
        EnumDyeColor config = ItemIlluminationWand.getConfiguredColor(wand);
        if (config != null) {
            return BlocksAS.blockVolatileLight.func_176223_P().func_177226_a(BlockFlareLight.COLOR, (Comparable)config);
        }
        return BlocksAS.blockVolatileLight.func_176223_P();
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemIlluminationWand)) {
            return EnumActionResult.SUCCESS;
        }
        if (!worldIn.field_72995_K) {
            TileTranslucent tt;
            IBlockState at = worldIn.func_180495_p(pos);
            if (!playerIn.func_70093_af()) {
                TileIlluminator illum = MiscUtils.getTileAt((IBlockAccess)worldIn, pos, TileIlluminator.class, false);
                if (illum != null) {
                    EnumDyeColor thisColor = ItemIlluminationWand.getConfiguredColor(stack);
                    if (thisColor == null) {
                        thisColor = EnumDyeColor.YELLOW;
                    }
                    illum.onWandUsed(thisColor);
                    this.drainTempCharge(playerIn, PlayerChargeHandler.INSTANCE.getCharge(playerIn), false);
                } else {
                    IBlockState iblockstate = worldIn.func_180495_p(pos);
                    Block block = iblockstate.func_177230_c();
                    if (!block.func_176200_f((IBlockAccess)worldIn, pos)) {
                        pos = pos.func_177972_a(facing);
                    }
                    if (playerIn.func_175151_a(pos, facing, stack)) {
                        if (worldIn.func_180495_p(pos).equals(ItemIlluminationWand.getPlacingState(stack))) {
                            SoundType soundtype = worldIn.func_180495_p(pos).func_177230_c().getSoundType(worldIn.func_180495_p(pos), worldIn, pos, (Entity)playerIn);
                            if (worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3)) {
                                worldIn.func_184133_a(playerIn, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                            }
                        } else if (worldIn.func_190527_a((Block)BlocksAS.blockVolatileLight, pos, true, facing, null) && this.drainTempCharge(playerIn, Config.illuminationWandUseCost, true) && worldIn.func_180501_a(pos, ItemIlluminationWand.getPlacingState(stack), 3)) {
                            SoundType soundtype = worldIn.func_180495_p(pos).func_177230_c().getSoundType(worldIn.func_180495_p(pos), worldIn, pos, (Entity)playerIn);
                            worldIn.func_184133_a(playerIn, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                            this.drainTempCharge(playerIn, Config.illuminationWandUseCost, false);
                        }
                    }
                }
            } else if (at.func_185915_l()) {
                TileEntity te = worldIn.func_175625_s(pos);
                if (te == null && !at.func_177230_c().hasTileEntity(at) && this.drainTempCharge(playerIn, Config.illuminationWandUseCost, true) && worldIn.func_180501_a(pos, BlocksAS.translucentBlock.func_176223_P(), 3)) {
                    TileTranslucent tt2 = MiscUtils.getTileAt((IBlockAccess)worldIn, pos, TileTranslucent.class, true);
                    if (tt2 == null) {
                        worldIn.func_180501_a(pos, at, 3);
                    } else {
                        tt2.setFakedState(at);
                        this.drainTempCharge(playerIn, Config.illuminationWandUseCost, false);
                    }
                }
            } else if (at.func_177230_c() instanceof BlockTranslucentBlock && (tt = MiscUtils.getTileAt((IBlockAccess)worldIn, pos, TileTranslucent.class, true)) != null && tt.getFakedState() != null) {
                worldIn.func_180501_a(pos, tt.getFakedState(), 3);
            }
        }
        return EnumActionResult.SUCCESS;
    }
}

