/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.gem;

import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.GemAttributeModifier;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import hellfirepvp.astralsorcery.common.item.gem.ItemPerkGem;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.Configuration;

public class GemAttributeHelper {
    private static final Random rand = new Random();
    private static Map<String, Integer> weightedModifiers = new HashMap<String, Integer>(){
        {
            this.put("astralsorcery.maxhealth", 12);
            this.put("astralsorcery.movespeed", 8);
            this.put("astralsorcery.armor", 8);
            this.put("astralsorcery.reach", 4);
            this.put("astralsorcery.attackspeed", 2);
            this.put("astralsorcery.meleeattackdamage", 8);
            this.put("astralsorcery.projectileattackdamage", 8);
            this.put("astralsorcery.liferecovery", 2);
            this.put("astralsorcery.harvestspeed", 2);
            this.put("astralsorcery.critchance", 4);
            this.put("astralsorcery.critmulti", 4);
            this.put("astralsorcery.allres", 2);
            this.put("astralsorcery.dodge", 2);
            this.put("astralsorcery.expgain", 1);
            this.put("astralsorcery.compat.thaumcraft.runicshield", 2);
        }
    };
    private static Map<String, Integer> configuredModifiers = Maps.newHashMap();
    private static float chance3Modifiers = 0.2f;
    private static float chance4Modifiers = 0.05f;
    private static boolean allowDuplicateTypes = false;
    private static float incModifierLower = 0.05f;
    private static float incModifierHigher = 0.08f;
    private static boolean allowNegativeModifiers = false;
    private static float chanceNegative = 0.25f;
    private static float decModifierLower = -0.05f;
    private static float decModifierHigher = -0.08f;
    private static boolean allowMoreLessModifiers = false;
    private static float chanceMultiplicative = 0.1f;
    private static float moreModifierLower = 0.05f;
    private static float moreModifierHigher = 0.08f;
    private static float lessModifierLower = -0.05f;
    private static float lessModifierHigher = -0.08f;

    public static boolean rollGem(ItemStack gem) {
        return GemAttributeHelper.rollGem(gem, rand);
    }

    public static boolean rollGem(ItemStack gem, Random random) {
        if (!ItemPerkGem.getModifiers(gem).isEmpty()) {
            return false;
        }
        ItemPerkGem.GemType gemType = ItemPerkGem.getGemType(gem);
        if (gemType == null) {
            return false;
        }
        int rolls = GemAttributeHelper.getPotentialMods(random, gemType.countModifier);
        ArrayList<GemAttributeModifier> mods = new ArrayList<GemAttributeModifier>();
        for (int i = 0; i < rolls; ++i) {
            float rValue;
            float lower;
            boolean isMultiplicative;
            String type = null;
            if (allowDuplicateTypes) {
                type = MiscUtils.getWeightedRandomEntry(configuredModifiers.keySet(), random, s -> configuredModifiers.getOrDefault(s, 1));
            } else {
                ArrayList<String> keys = new ArrayList<String>(configuredModifiers.keySet());
                while (!keys.isEmpty() && type == null) {
                    String item = GemAttributeHelper.getWeightedResultAndRemove(keys, random);
                    if (item == null) continue;
                    boolean foundType = false;
                    for (GemAttributeModifier m : mods) {
                        if (!m.getAttributeType().equals(item)) continue;
                        foundType = true;
                    }
                    if (foundType) continue;
                    type = item;
                }
            }
            if (type == null) continue;
            boolean isNegative = allowNegativeModifiers && random.nextFloat() < chanceNegative;
            boolean bl = isMultiplicative = allowMoreLessModifiers && random.nextFloat() < chanceMultiplicative;
            float f = isNegative ? (isMultiplicative ? lessModifierLower : decModifierLower) : (lower = isMultiplicative ? moreModifierLower : incModifierLower);
            float higher = isNegative ? (isMultiplicative ? lessModifierHigher : decModifierHigher) : (isMultiplicative ? moreModifierHigher : incModifierHigher);
            float value = lower > higher ? lower : lower + MathHelper.func_76131_a((float)(random.nextFloat() * gemType.amplifierModifier), (float)0.0f, (float)1.0f) * (higher - lower);
            PerkAttributeModifier.Mode mode = isMultiplicative ? PerkAttributeModifier.Mode.STACKING_MULTIPLY : PerkAttributeModifier.Mode.ADDED_MULTIPLY;
            float f2 = rValue = isMultiplicative ? 1.0f + value : value;
            if (allowDuplicateTypes) {
                String fType = type;
                GemAttributeModifier existing = MiscUtils.iterativeSearch(mods, mod -> mod.getAttributeType().equals(fType) && mod.getMode().equals((Object)mode));
                if (existing != null) {
                    mods.remove(existing);
                    float combinedValue = isMultiplicative ? existing.getFlatValue() - 1.0f + (rValue - 1.0f) : existing.getFlatValue() + rValue;
                    if (combinedValue == 0.0f) continue;
                    mods.add(new GemAttributeModifier(UUID.randomUUID(), type, mode, isMultiplicative ? combinedValue + 1.0f : combinedValue));
                    continue;
                }
                mods.add(new GemAttributeModifier(UUID.randomUUID(), type, mode, rValue));
                continue;
            }
            mods.add(new GemAttributeModifier(UUID.randomUUID(), type, mode, rValue));
        }
        ItemPerkGem.setModifiers(gem, mods);
        return true;
    }

    @Nullable
    private static String getWeightedResultAndRemove(List<String> list, Random random) {
        if (list.isEmpty()) {
            return null;
        }
        String result = MiscUtils.getWeightedRandomEntry(list, random, s -> configuredModifiers.getOrDefault(s, 1));
        if (result != null) {
            list.remove(result);
        }
        return result;
    }

    private static int getPotentialMods(Random random, float countModifier) {
        int mods = 2;
        if (random.nextFloat() < chance3Modifiers * countModifier) {
            ++mods;
            if (random.nextFloat() < chance4Modifiers * countModifier) {
                ++mods;
            }
        }
        return mods;
    }

    public static class CfgEntry
    extends ConfigEntry {
        public CfgEntry() {
            super(ConfigEntry.Section.PERKS, "gem");
        }

        @Override
        public void loadFromConfig(Configuration cfg) {
            configuredModifiers.clear();
            List<String> flattened = MiscUtils.flatten(weightedModifiers, (key, weight) -> key + "=" + weight);
            String[] arr = flattened.toArray(new String[flattened.size()]);
            String[] configuredList = cfg.getStringList(this.getKey() + "WeightedModifiers", this.getConfigurationSection(), arr, "List of weighted modifiers the gem may roll. Format: 'modifier=weight'");
            this.fillModifiers(configuredList);
            allowDuplicateTypes = cfg.getBoolean(this.getKey() + "AllowDuplicateTypes", this.getConfigurationSection(), allowDuplicateTypes, "If this is set to true, the same type of modifier (e.g. maxhealth) can roll multiple times");
            chance3Modifiers = cfg.getFloat(this.getKey() + "Chance3Modifiers", this.getConfigurationSection(), chance3Modifiers, 0.0f, 1.0f, "Defines the chance the gem can roll a 3rd modifier. The lower this chance, the rarer.");
            chance4Modifiers = cfg.getFloat(this.getKey() + "Chance4Modifiers", this.getConfigurationSection(), chance4Modifiers, 0.0f, 1.0f, "Defines the chance the gem can roll a 4th modifier. A 3rd modifier MUST be rolled before and the chances are independent of each other. The lower this chance, the rarer.");
            allowNegativeModifiers = cfg.getBoolean(this.getKey() + "AllowNegativeModifier", this.getConfigurationSection(), allowNegativeModifiers, "If this is set to true, a modifier may roll negative instead of positive, depending on the configured chance (see ChanceNegativeModifier)");
            chanceNegative = cfg.getFloat(this.getKey() + "ChanceNegativeModifier", this.getConfigurationSection(), chanceNegative, 0.0f, 1.0f, "If 'AllowNegativeModifier' is set to true, this defines the chance a given modifier may be negative instead of positive.");
            allowMoreLessModifiers = cfg.getBoolean(this.getKey() + "AllowMoreLessModifier", this.getConfigurationSection(), allowMoreLessModifiers, "If this is set to true, a modifier may roll to be 'more'/'less' instead of 'increased'/'decreased', depending on the configured chance (see ChanceMoreLessModifier)");
            chanceMultiplicative = cfg.getFloat(this.getKey() + "ChanceMoreLessModifier", this.getConfigurationSection(), chanceMultiplicative, 0.0f, 1.0f, "If 'AllowMoreLessModifier' is set to true, this defines the chance a given modifier may be 'more'/'less' instead of 'increased'/'decreased'.");
            String section = this.getConfigurationSection() + ".ranges";
            incModifierLower = cfg.getFloat("Increased_Lower_Bound", section, incModifierLower, 0.0f, 1.0f, "Defines the lower bound an 'increased' modifier can roll. Value is in percent (0.01 means 1%, 0.1 means 10%, ...)");
            incModifierHigher = cfg.getFloat("Increased_Higher_Bound", section, incModifierHigher, 0.0f, 1.0f, "Defines the lower bound an 'increased' modifier can roll. Value is in percent (0.01 means 1%, 0.1 means 10%, ...)");
            decModifierLower = cfg.getFloat("Decreased_Lower_Bound", section, decModifierLower, -1.0f, 0.0f, "Defines the lower bound an 'decreased' modifier can roll. Value is in percent (-0.01 means 1% decreased, -0.1 means 10% decreased, ...)");
            decModifierHigher = cfg.getFloat("Decreased_Higher_Bound", section, decModifierHigher, -1.0f, 0.0f, "Defines the lower bound an 'decreased' modifier can roll. Value is in percent (-0.01 means 1% decreased, -0.1 means 10% decreased, ...)");
            moreModifierLower = cfg.getFloat("More_Lower_Bound", section, moreModifierLower, 0.0f, 1.0f, "Defines the lower bound an 'more' modifier can roll. Value is in percent (0.01 means 1%, 0.1 means 10%, ...)");
            moreModifierHigher = cfg.getFloat("More_Higher_Bound", section, moreModifierHigher, 0.0f, 1.0f, "Defines the lower bound an 'more' modifier can roll. Value is in percent (0.01 means 1%, 0.1 means 10%, ...)");
            lessModifierLower = cfg.getFloat("Less_Lower_Bound", section, lessModifierLower, -1.0f, 0.0f, "Defines the lower bound an 'less' modifier can roll. Value is in percent (-0.01 means 1% less, -0.1 means 10% less, ...)");
            lessModifierHigher = cfg.getFloat("Less_Higher_Bound", section, lessModifierHigher, -1.0f, 0.0f, "Defines the lower bound an 'less' modifier can roll. Value is in percent (-0.01 means 1% less, -0.1 means 10% less, ...)");
        }

        private void fillModifiers(String[] configuredList) {
            for (String s : configuredList) {
                int weight;
                String[] spl = s.split("=");
                if (spl.length != 2) {
                    AstralSorcery.log.info("Ignoring wrong format for gem attribute modifier: " + s + " (Too many/not enough '=' found!)");
                    continue;
                }
                String key = spl[0];
                String strWeight = spl[1];
                try {
                    weight = Integer.parseInt(strWeight);
                }
                catch (NumberFormatException exc) {
                    AstralSorcery.log.info("Ignoring wrong format for gem attribute modifier: " + s + " (The weight '" + strWeight + "' is not an integer number!)");
                    continue;
                }
                configuredModifiers.put(key, weight);
            }
        }
    }
}

