/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker;

import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;

public abstract class BaseTweaker {
    @Nonnull
    public static ItemStack convertToItemStack(IItemStack stack) {
        return CraftTweakerMC.getItemStack((IItemStack)stack);
    }

    @Nullable
    public static FluidStack convertToFluidStack(ILiquidStack stack, boolean capAndLimitToBuckets) {
        FluidStack fs = CraftTweakerMC.getLiquidStack((ILiquidStack)stack);
        if (fs != null && capAndLimitToBuckets) {
            fs.amount = 1000;
        }
        return fs;
    }

    @Nullable
    public static ItemHandle convertToHandle(IIngredient obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof IItemStack) {
            ItemStack ret = BaseTweaker.convertToItemStack((IItemStack)obj);
            if (ret.func_190926_b()) {
                return null;
            }
            return new ItemHandle(ret);
        }
        if (obj instanceof ILiquidStack) {
            FluidStack ret = BaseTweaker.convertToFluidStack((ILiquidStack)obj, true);
            if (ret == null) {
                return null;
            }
            return new ItemHandle(ret);
        }
        if (obj instanceof IOreDictEntry) {
            return new ItemHandle(((IOreDictEntry)obj).getName());
        }
        NonNullList stacks = NonNullList.func_191196_a();
        for (IItemStack in : obj.getItems()) {
            ItemStack real = BaseTweaker.convertToItemStack(in);
            if (real.func_190926_b()) continue;
            stacks.add((Object)real);
        }
        return new ItemHandle((NonNullList<ItemStack>)stacks);
    }
}

