/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.altar.recipes;

import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.TraitRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.AccessibleRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapeMap;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import hellfirepvp.astralsorcery.common.item.wearable.ItemCape;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class CapeAttunementRecipe
extends TraitRecipe {
    private final IConstellation constellation;

    public CapeAttunementRecipe(IConstellation constellation, AccessibleRecipe recipe) {
        super(recipe);
        this.setPassiveStarlightRequirement(3000);
        this.constellation = constellation;
        this.setRequiredConstellation(constellation);
    }

    @Override
    @Nonnull
    public ItemStack getOutputForRender() {
        ItemStack cPaper = new ItemStack((Item)ItemsAS.armorImbuedCape);
        ItemCape.setAttunedConstellation(cPaper, this.constellation);
        return cPaper;
    }

    @Override
    @Nonnull
    public ItemStack getOutputForMatching() {
        ItemStack cPaper = new ItemStack((Item)ItemsAS.armorImbuedCape);
        ItemCape.setAttunedConstellation(cPaper, this.constellation);
        return cPaper;
    }

    @Override
    @Nonnull
    public ItemStack getOutput(ShapeMap centralGridMap, TileAltar altar) {
        ItemStack cape = new ItemStack((Item)ItemsAS.armorImbuedCape);
        ItemStack center = altar.getInventoryHandler().getStackInSlot(ShapedRecipeSlot.CENTER.getSlotID());
        if (!center.func_190926_b() && center.func_77973_b() instanceof ItemCape) {
            cape = ItemUtils.copyStackWithSize(center, center.func_190916_E());
        }
        ItemCape.setAttunedConstellation(cape, this.constellation);
        return cape;
    }
}

