/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.util;

import hellfirepvp.astralsorcery.client.util.AirBlockRenderWorld;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.common.structure.array.BlockArray;
import hellfirepvp.astralsorcery.common.structure.array.PatternBlockArray;
import hellfirepvp.astralsorcery.common.tile.IMultiblockDependantTile;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Biomes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;

public class StructureMatchPreview {
    private final IMultiblockDependantTile tile;
    private int timeout;

    public StructureMatchPreview(IMultiblockDependantTile tile) {
        this.tile = tile;
        this.timeout = 100;
    }

    public void tick() {
        PatternBlockArray pattern = this.tile.getRequiredStructure();
        if (pattern != null && Minecraft.func_71410_x().field_71439_g != null) {
            BlockPos at = this.tile.getLocationPos();
            Vec3i v = pattern.getSize();
            int maxDim = Math.max(Math.max(v.func_177958_n(), v.func_177956_o()), v.func_177952_p());
            maxDim = Math.max(9, maxDim);
            if (Minecraft.func_71410_x().field_71439_g.func_70011_f((double)at.func_177958_n(), (double)at.func_177956_o(), (double)at.func_177952_p()) <= (double)maxDim) {
                this.resetTimeout();
                return;
            }
        }
        --this.timeout;
    }

    public void resetTimeout() {
        this.timeout = 300;
    }

    @Nullable
    public Integer getPreviewSlice() {
        int minY;
        PatternBlockArray pattern = this.tile.getRequiredStructure();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (pattern == null || world == null) {
            return null;
        }
        for (int y = minY = pattern.getMin().func_177956_o(); y <= pattern.getMax().func_177956_o(); ++y) {
            if (pattern.matchesSlice((World)world, this.tile.getLocationPos(), y)) continue;
            return y;
        }
        return null;
    }

    public boolean shouldBeRemoved() {
        return this.timeout <= 0 || this.tile.getRequiredStructure() == null || Minecraft.func_71410_x().field_71441_e == null || Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension() != ((TileEntity)this.tile).func_145831_w().field_73011_w.getDimension() || this.tile.getRequiredStructure().matches((World)Minecraft.func_71410_x().field_71441_e, ((TileEntity)this.tile).func_174877_v()) || ((TileEntity)this.tile).func_145837_r();
    }

    public boolean isOriginatingFrom(IMultiblockDependantTile tile) {
        if (!(tile instanceof TileEntity)) {
            return false;
        }
        if (this.shouldBeRemoved()) {
            return false;
        }
        return ((TileEntity)this.tile).func_174877_v().equals((Object)((TileEntity)tile).func_174877_v());
    }

    public void renderPreview(float partialTicks) {
        PatternBlockArray pba = this.tile.getRequiredStructure();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Integer slice = this.getPreviewSlice();
        if (this.shouldBeRemoved() || pba == null || slice == null || world == null) {
            return;
        }
        BlockPos center = this.tile.getLocationPos();
        AirBlockRenderWorld airWorld = new AirBlockRenderWorld(Biomes.field_76772_c, WorldType.field_180272_g);
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        TextureHelper.setActiveTextureToAtlasSprite();
        GlStateManager.func_179118_c();
        GlStateManager.func_179097_i();
        GlStateManager.func_179131_c((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        GlStateManager.func_179147_l();
        Blending.CONSTANT_ALPHA.applyStateManager();
        GlStateManager.func_179094_E();
        RenderingUtils.removeStandartTranslationFromTESRMatrix(partialTicks);
        GlStateManager.func_179109_b((float)center.func_177958_n(), (float)center.func_177956_o(), (float)center.func_177952_p());
        for (Map.Entry<BlockPos, BlockArray.BlockInformation> patternEntry : pba.getPatternSlice(slice).entrySet()) {
            BlockPos offset = patternEntry.getKey();
            BlockArray.BlockInformation info = patternEntry.getValue();
            if (offset.equals((Object)BlockPos.field_177992_a) || pba.matchSingleBlock((IBlockAccess)world, center, offset)) continue;
            IBlockState state = world.func_180495_p(center.func_177971_a((Vec3i)offset));
            vb.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)offset.func_177958_n(), (float)offset.func_177956_o(), (float)offset.func_177952_p());
            GlStateManager.func_179137_b((double)0.125, (double)0.125, (double)0.125);
            GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
            if (state.func_177230_c().isAir(state, (IBlockAccess)world, center.func_177971_a((Vec3i)offset))) {
                RenderingUtils.renderBlockSafely(airWorld, BlockPos.field_177992_a, info.state, vb);
            } else {
                RenderingUtils.renderBlockSafelyWithOptionalColor(airWorld, BlockPos.field_177992_a, info.state, vb, 0xFF0000);
            }
            tes.func_78381_a();
            GlStateManager.func_179121_F();
        }
        Blending.DEFAULT.applyStateManager();
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179121_F();
        TextureHelper.refreshTextureBindState();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

