/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes;

import appeng.recipes.IAERecipeFactory;
import appeng.recipes.handlers.GrinderHandler;
import appeng.recipes.handlers.InscriberHandler;
import appeng.recipes.handlers.SmeltingHandler;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class AERecipeLoader {
    private static final String AERECIPE_BASE = "/aerecipes";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<ResourceLocation, IAERecipeFactory> factories = new HashMap<ResourceLocation, IAERecipeFactory>();
    private final ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get("appliedenergistics2");
    private final JsonContext ctx = new JsonContext("appliedenergistics2");

    public AERecipeLoader() {
        this.initFactories();
    }

    public boolean loadProcessingRecipes() {
        return CraftingHelper.findFiles((ModContainer)this.mod, (String)"assets/appliedenergistics2/aerecipes", this::preprocess, this::process, (boolean)true, (boolean)true);
    }

    private boolean preprocess(Path root) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean process(Path root, Path file) {
        String relative = root.relativize(file).toString();
        if (!"json".equals(FilenameUtils.getExtension((String)file.toString())) || relative.startsWith("_")) {
            return true;
        }
        String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
        ResourceLocation key = new ResourceLocation(this.ctx.getModId(), name);
        BufferedReader reader = null;
        try {
            reader = Files.newBufferedReader(file);
            JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
            if (json.has("conditions") && !CraftingHelper.processConditions((JsonArray)JsonUtils.func_151214_t((JsonObject)json, (String)"conditions"), (JsonContext)this.ctx)) {
                boolean bl = true;
                return bl;
            }
            this.register(json);
        }
        catch (JsonParseException e) {
            FMLLog.log.error("Parsing error loading recipe {}", (Object)key, (Object)e);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            FMLLog.log.error("Couldn't read recipe {} from {}", (Object)key, (Object)file, (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        return true;
    }

    private void register(JsonObject json) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Json cannot be null");
        }
        String type = this.ctx.appendModId(JsonUtils.func_151200_h((JsonObject)json, (String)"type"));
        if (type.isEmpty()) {
            throw new JsonSyntaxException("Recipe type can not be an empty string");
        }
        IAERecipeFactory factory = this.factories.get(new ResourceLocation(type));
        if (factory == null) {
            throw new JsonSyntaxException("Unknown recipe type: " + type);
        }
        factory.register(json, this.ctx);
    }

    private void initFactories() {
        this.factories.put(new ResourceLocation("appliedenergistics2", "inscriber"), new InscriberHandler());
        this.factories.put(new ResourceLocation("appliedenergistics2", "smelt"), new SmeltingHandler());
        this.factories.put(new ResourceLocation("appliedenergistics2", "grinder"), new GrinderHandler());
    }
}

