/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration;

import appeng.api.exceptions.ModNotInstalledException;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.integration.IIntegrationModule;
import appeng.integration.IntegrationStage;
import appeng.integration.IntegrationType;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModAPIManager;

final class IntegrationNode {
    private final String displayName;
    private final String modID;
    private final IntegrationType type;
    private IntegrationStage state = IntegrationStage.PRE_INIT;
    private Throwable exception = null;
    private IIntegrationModule mod = null;

    IntegrationNode(String displayName, String modID, IntegrationType type) {
        this.displayName = displayName;
        this.type = type;
        this.modID = modID;
    }

    public String toString() {
        return this.getType().name() + ':' + this.getState().name();
    }

    boolean isActive() {
        if (this.getState() == IntegrationStage.PRE_INIT) {
            this.call(IntegrationStage.PRE_INIT);
        }
        return this.getState() != IntegrationStage.FAILED;
    }

    void call(IntegrationStage stage) {
        if (this.getState() != IntegrationStage.FAILED) {
            if (this.getState().ordinal() > stage.ordinal()) {
                return;
            }
            try {
                switch (stage) {
                    case PRE_INIT: {
                        ModAPIManager apiManager = ModAPIManager.INSTANCE;
                        boolean enabled = this.modID == null || Loader.isModLoaded((String)this.modID) || apiManager.hasAPI(this.modID);
                        AEConfig.instance().addCustomCategoryComment("ModIntegration", "Valid Values are 'AUTO', 'ON', or 'OFF' - defaults to 'AUTO' ; Suggested that you leave this alone unless your experiencing an issue, or wish to disable the integration for a reason.");
                        String mode = AEConfig.instance().get("ModIntegration", this.displayName.replace(" ", ""), "AUTO").getString();
                        if (mode.equalsIgnoreCase("ON")) {
                            enabled = true;
                        }
                        if (mode.equalsIgnoreCase("OFF")) {
                            enabled = false;
                        }
                        if (!enabled) {
                            throw new ModNotInstalledException(this.modID);
                        }
                        this.mod = this.type.createInstance();
                        this.mod.preInit();
                        this.setState(IntegrationStage.INIT);
                        break;
                    }
                    case INIT: {
                        this.mod.init();
                        this.setState(IntegrationStage.POST_INIT);
                        break;
                    }
                    case POST_INIT: {
                        this.mod.postInit();
                        this.setState(IntegrationStage.READY);
                        break;
                    }
                }
            }
            catch (Throwable t) {
                this.exception = t;
                this.setState(IntegrationStage.FAILED);
            }
        }
        if (stage == IntegrationStage.POST_INIT) {
            if (this.getState() == IntegrationStage.FAILED) {
                AELog.info(this.displayName + " - Integration Disabled", new Object[0]);
                if (!(this.exception instanceof ModNotInstalledException)) {
                    AELog.integration(this.exception);
                }
            } else {
                AELog.info(this.displayName + " - Integration Enable", new Object[0]);
            }
        }
    }

    IntegrationType getType() {
        return this.type;
    }

    IntegrationStage getState() {
        return this.state;
    }

    private void setState(IntegrationStage state) {
        this.state = state;
    }
}

