/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.renderers.blocks;

import com.infinityraider.agricraft.api.v1.util.AgriSideMetaMatrix;
import com.infinityraider.agricraft.blocks.BlockWaterPad;
import com.infinityraider.agricraft.reference.AgriProperties;
import com.infinityraider.agricraft.utility.BaseIcons;
import com.infinityraider.infinitylib.block.BlockBase;
import com.infinityraider.infinitylib.render.block.RenderBlockBase;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderWaterPad
extends RenderBlockBase<BlockWaterPad> {
    public RenderWaterPad(BlockWaterPad block) {
        super((BlockBase)block, true);
    }

    public List<ResourceLocation> getAllTextures() {
        return Collections.emptyList();
    }

    public void renderWorldBlockStatic(ITessellator tessellator, IBlockState state, BlockWaterPad block, EnumFacing side) {
        TextureAtlasSprite matIcon = BaseIcons.DIRT.getIcon();
        TextureAtlasSprite waterIcon = BaseIcons.WATER_STILL.getIcon();
        RenderWaterPad.renderBase(tessellator, matIcon);
        AgriSideMetaMatrix connections = new AgriSideMetaMatrix();
        connections.readFromBlockState(state);
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            if (connections.get(dir) >= 1) continue;
            RenderWaterPad.renderSide(tessellator, dir, matIcon);
        }
        if (((Boolean)AgriProperties.POWERED.getValue(state)).booleanValue()) {
            RenderWaterPad.renderWater(tessellator, waterIcon);
        }
    }

    public void renderInventoryBlock(ITessellator tess, World world, IBlockState state, BlockWaterPad block, ItemStack stack, EntityLivingBase entity, ItemCameraTransforms.TransformType type) {
        TextureAtlasSprite matIcon = BaseIcons.DIRT.getIcon();
        TextureAtlasSprite waterIcon = BaseIcons.WATER_STILL.getIcon();
        RenderWaterPad.renderBase(tess, matIcon);
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            RenderWaterPad.renderSide(tess, dir, matIcon);
        }
        if (((Boolean)AgriProperties.POWERED.getValue(state)).booleanValue()) {
            RenderWaterPad.renderWater(tess, waterIcon);
        }
    }

    private static void renderWater(ITessellator tess, TextureAtlasSprite waterIcon) {
        tess.drawScaledFaceDouble(0.0f, 0.0f, 16.0f, 16.0f, EnumFacing.UP, waterIcon, 15.0f);
    }

    private static void renderBase(ITessellator tess, TextureAtlasSprite matIcon) {
        tess.drawScaledPrism(0.0f, 0.0f, 0.0f, 16.0f, 8.0f, 16.0f, matIcon);
    }

    private static void renderSide(ITessellator tess, EnumFacing side, TextureAtlasSprite matIcon) {
        boolean xAxis = side.func_176740_k() == EnumFacing.Axis.X;
        int index = xAxis ? side.func_82601_c() : side.func_82599_e();
        int min = index < 0 ? 0 : 15;
        int max = index < 0 ? 1 : 16;
        tess.drawScaledFace(xAxis ? (float)min : 0.0f, xAxis ? 0.0f : (float)min, xAxis ? (float)max : 16.0f, xAxis ? 16.0f : (float)max, EnumFacing.UP, matIcon, 16.0f);
        tess.drawScaledFace(0.0f, 8.0f, 16.0f, 16.0f, side, matIcon, index > 0 ? 16.0f : 0.0f);
        tess.drawScaledFace(0.0f, 8.0f, 16.0f, 16.0f, side.func_176734_d(), matIcon, index > 0 ? 15.0f : 1.0f);
    }

    public TextureAtlasSprite getIcon() {
        return BaseIcons.DIRT.getIcon();
    }

    public boolean applyAmbientOcclusion() {
        return true;
    }
}

