/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.crop;

import com.infinityraider.agricraft.api.v1.fertilizer.IAgriFertilizable;
import com.infinityraider.agricraft.api.v1.misc.IAgriHarvestable;
import com.infinityraider.agricraft.api.v1.misc.IAgriRakeable;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.seed.AgriSeed;
import com.infinityraider.agricraft.api.v1.seed.IAgriSeedAcceptor;
import com.infinityraider.agricraft.api.v1.seed.IAgriSeedProvider;
import com.infinityraider.agricraft.api.v1.soil.IAgriSoil;
import com.infinityraider.agricraft.api.v1.util.MethodResult;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface IAgriCrop
extends IAgriSeedProvider,
IAgriSeedAcceptor,
IAgriFertilizable,
IAgriHarvestable,
IAgriRakeable {
    public BlockPos getCropPos();

    public World getCropWorld();

    public int getGrowthStage();

    public boolean setGrowthStage(int var1);

    public boolean isCrossCrop();

    public boolean setCrossCrop(boolean var1);

    default public boolean isFertile() {
        return this.hasSeed() && this.isFertile(this.getSeed());
    }

    default public boolean isFertile(@Nullable AgriSeed seed) {
        return seed != null && this.isFertile(seed.getPlant());
    }

    public boolean isFertile(@Nullable IAgriPlant var1);

    public boolean isMature();

    @Nonnull
    public Optional<IAgriSoil> getSoil();

    @Override
    default public boolean canBeHarvested() {
        return this.hasSeed() && this.isMature();
    }

    @Override
    default public boolean canBeRaked() {
        return this.hasSeed();
    }

    @Nonnull
    public MethodResult onGrowthTick();

    @Nonnull
    public MethodResult onApplyCrops(@Nullable EntityPlayer var1);

    @Nonnull
    public MethodResult onApplySeeds(@Nonnull AgriSeed var1, @Nullable EntityPlayer var2);

    @Nonnull
    public MethodResult onBroken(@Nonnull Consumer<ItemStack> var1, @Nullable EntityPlayer var2);
}

