/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.world.dungeon;

import com.gildedgames.the_aether.blocks.BlocksAether;
import com.gildedgames.the_aether.blocks.dungeon.BlockDungeonBase;
import com.gildedgames.the_aether.blocks.dungeon.BlockTreasureChest;
import com.gildedgames.the_aether.blocks.natural.BlockHolystone;
import com.gildedgames.the_aether.blocks.util.EnumStoneType;
import com.gildedgames.the_aether.entities.bosses.slider.EntitySlider;
import com.gildedgames.the_aether.events.BronzeDungeonSizeEvent;
import com.gildedgames.the_aether.world.dungeon.util.AetherDungeonVirtual;
import com.gildedgames.the_aether.world.dungeon.util.PositionData;
import com.gildedgames.the_aether.world.util.RandomTracker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BronzeDungeon
extends AetherDungeonVirtual {
    private boolean needsCorridor = false;
    private int roomMaximum;
    private int roomCount;

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        BronzeDungeonSizeEvent event = new BronzeDungeonSizeEvent(random.nextInt(6) + 2);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.replaceAir = true;
        this.replaceSolid = true;
        this.roomMaximum = event.getDungeonRoomMaximum();
        this.roomCount = 0;
        this.preGenerate(world, random, pos);
        return true;
    }

    public boolean preGenerate(World world, Random random, BlockPos pos) {
        if (!this.isBoxSolid(world, new PositionData(pos.func_177958_n(), pos.func_177956_o() - 3, pos.func_177952_p()), new PositionData(16, 18, 16)) || this.isSpaceTaken(world, new PositionData(pos.func_177958_n(), pos.func_177956_o() - 3, pos.func_177952_p()), new PositionData(16, 16, 16))) {
            return false;
        }
        RandomTracker randomTracker = new RandomTracker();
        if (randomTracker.testRandom(random, 15) != 0 && randomTracker.testRandom(random, 40) != 0) {
            return false;
        }
        this.setBlocks(this.lockedBlock(), this.lockedLightBlock(), 20);
        this.addHollowBox(world, random, new PositionData(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), new PositionData(16, 12, 16));
        this.addHollowBox(world, random, new PositionData(pos.func_177958_n() + 6, pos.func_177956_o() - 2, pos.func_177952_p() + 6), new PositionData(4, 4, 4));
        EntitySlider slider = new EntitySlider(world);
        slider.func_70107_b(pos.func_177958_n() + 8, pos.func_177956_o() + 2, pos.func_177952_p() + 8);
        slider.setDungeon(slider.field_70165_t - 8.0, slider.field_70163_u - 2.0, slider.field_70161_v - 8.0);
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)slider);
        }
        this.storeReplacementBlock(world, pos.func_177982_a(7, -1, 7), ((BlockTreasureChest)BlocksAether.treasure_chest).correctFacing(world, pos.func_177982_a(7, -1, 7), BlocksAether.treasure_chest.func_176223_P()));
        this.generateEmptyRoom(world, random, pos, slider);
        return true;
    }

    public boolean generateEmptyRoom(World world, Random random, BlockPos pos, EntitySlider slider) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177956_o();
        int rooms = random.nextInt(4);
        switch (rooms) {
            case 0: {
                x = pos.func_177958_n() + 20;
                y = pos.func_177956_o();
                z = pos.func_177952_p() + 2;
                if (!this.isBoxSolid(world, new PositionData(x, y, z), new PositionData(12, 12, 12)) || this.isSpaceTaken(world, new PositionData(x, y, z), new PositionData(12, 12, 12))) {
                    this.placementStorage.clear();
                    this.replacementStorage.clear();
                    slider.func_70106_y();
                    return false;
                }
                this.setBlocks(this.mainBlock(), this.mainLightBlock(), 20);
                this.addHollowBox(world, random, new PositionData(x, y, z), new PositionData(12, 12, 12));
                this.setBlocks(this.fillerBlock(), this.fillerBlock1(), 5);
                this.addSquareTube(world, random, new PositionData(x - 5, y, z + 3), new PositionData(6, 6, 6), 0);
                for (int p = x + 2; p < x + 10; p += 3) {
                    for (int q = z + 2; q < z + 10; q += 3) {
                        if (this.placementStorage.get(new BlockPos.MutableBlockPos().func_181079_c(p, pos.func_177956_o(), q)) == Blocks.field_150350_a || this.placementStorage.get(new BlockPos.MutableBlockPos().func_181079_c(p, pos.func_177956_o(), q)) == null) continue;
                        this.storeReplacementBlock(world, new BlockPos(p, pos.func_177956_o(), q), BlocksAether.dungeon_trap.func_176223_P());
                    }
                }
                break;
            }
            case 1: {
                x = pos.func_177958_n() - 16;
                y = pos.func_177956_o();
                z = pos.func_177952_p() + 2;
                if (!this.isBoxSolid(world, new PositionData(x, y, z), new PositionData(12, 12, 12)) || this.isSpaceTaken(world, new PositionData(x, y, z), new PositionData(12, 12, 12))) {
                    this.placementStorage.clear();
                    this.replacementStorage.clear();
                    slider.func_70106_y();
                    return false;
                }
                this.setBlocks(this.mainBlock(), this.mainLightBlock(), 20);
                this.addHollowBox(world, random, new PositionData(x, y, z), new PositionData(12, 12, 12));
                this.setBlocks(this.fillerBlock(), this.fillerBlock1(), 5);
                this.addSquareTube(world, random, new PositionData(x + 11, y, z + 3), new PositionData(6, 6, 6), 0);
                for (int p = x + 2; p < x + 10; p += 3) {
                    for (int q = z + 2; q < z + 10; q += 3) {
                        if (this.placementStorage.get(new BlockPos.MutableBlockPos().func_181079_c(p, pos.func_177956_o(), q)) == Blocks.field_150350_a || this.placementStorage.get(new BlockPos.MutableBlockPos().func_181079_c(p, pos.func_177956_o(), q)) == null) continue;
                        this.storeReplacementBlock(world, new BlockPos(p, pos.func_177956_o(), q), BlocksAether.dungeon_trap.func_176223_P());
                    }
                }
                break;
            }
            case 2: {
                x = pos.func_177958_n() + 2;
                y = pos.func_177956_o();
                z = pos.func_177952_p() + 20;
                if (!this.isBoxSolid(world, new PositionData(x, y, z), new PositionData(12, 12, 12)) || this.isSpaceTaken(world, new PositionData(x, y, z), new PositionData(12, 12, 12))) {
                    this.placementStorage.clear();
                    this.replacementStorage.clear();
                    slider.func_70106_y();
                    return false;
                }
                this.setBlocks(this.mainBlock(), this.mainLightBlock(), 20);
                this.addHollowBox(world, random, new PositionData(x, y, z), new PositionData(12, 12, 12));
                this.setBlocks(this.fillerBlock(), this.fillerBlock1(), 5);
                this.addSquareTube(world, random, new PositionData(x + 3, y, z - 5), new PositionData(6, 6, 6), 2);
                for (int p = x + 2; p < x + 10; p += 3) {
                    for (int q = z + 2; q < z + 10; q += 3) {
                        if (this.placementStorage.get(new BlockPos.MutableBlockPos().func_181079_c(p, pos.func_177956_o(), q)) == Blocks.field_150350_a || this.placementStorage.get(new BlockPos.MutableBlockPos().func_181079_c(p, pos.func_177956_o(), q)) == null) continue;
                        this.storeReplacementBlock(world, new BlockPos(p, pos.func_177956_o(), q), BlocksAether.dungeon_trap.func_176223_P());
                    }
                }
                break;
            }
            case 3: {
                x = pos.func_177958_n() + 2;
                y = pos.func_177956_o();
                z = pos.func_177952_p() - 16;
                if (!this.isBoxSolid(world, new PositionData(x, y, z), new PositionData(12, 12, 12)) || this.isSpaceTaken(world, new PositionData(x, y, z), new PositionData(12, 12, 12))) {
                    this.placementStorage.clear();
                    this.replacementStorage.clear();
                    slider.func_70106_y();
                    return false;
                }
                this.setBlocks(this.mainBlock(), this.mainLightBlock(), 20);
                this.addHollowBox(world, random, new PositionData(x, y, z), new PositionData(12, 12, 12));
                this.setBlocks(this.fillerBlock(), this.fillerBlock1(), 5);
                this.addSquareTube(world, random, new PositionData(x + 3, y, z + 11), new PositionData(6, 6, 6), 2);
                for (int p = x + 2; p < x + 10; p += 3) {
                    for (int q = z + 2; q < z + 10; q += 3) {
                        if (this.placementStorage.get(new BlockPos.MutableBlockPos().func_181079_c(p, pos.func_177956_o(), q)) == Blocks.field_150350_a || this.placementStorage.get(new BlockPos.MutableBlockPos().func_181079_c(p, pos.func_177956_o(), q)) == null) continue;
                        this.storeReplacementBlock(world, new BlockPos(p, pos.func_177956_o(), q), BlocksAether.dungeon_trap.func_176223_P());
                    }
                }
                break;
            }
        }
        if (!this.determineRoomPosition(world, random, new PositionData(x, y, z)) && this.roomCount == 0) {
            this.placementStorage.clear();
            this.replacementStorage.clear();
            slider.func_70106_y();
            return false;
        }
        if (this.needsCorridor) {
            this.endCorridor(world, random, new PositionData(x, y, z));
        }
        return true;
    }

    public boolean determineRoomPosition(World world, Random random, PositionData pos) {
        if (this.roomCount >= this.roomMaximum) {
            this.needsCorridor = true;
            return true;
        }
        ArrayList<Integer> sides = new ArrayList<Integer>();
        sides.add(1);
        sides.add(2);
        sides.add(3);
        sides.add(4);
        Collections.shuffle(sides);
        if (this.generateRoomWithSide(world, random, pos, (Integer)sides.get(0))) {
            return true;
        }
        if (this.generateRoomWithSide(world, random, pos, (Integer)sides.get(1))) {
            return true;
        }
        if (this.generateRoomWithSide(world, random, pos, (Integer)sides.get(2))) {
            return true;
        }
        if (this.generateRoomWithSide(world, random, pos, (Integer)sides.get(3))) {
            return true;
        }
        this.needsCorridor = true;
        return false;
    }

    public boolean generateRoomWithSide(World world, Random random, PositionData pos, int switchCase) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        int dir = 0;
        switch (switchCase) {
            case 1: {
                x += 16;
                z += 0;
                dir = 0;
                break;
            }
            case 2: {
                x += 0;
                z += 16;
                dir = 1;
                break;
            }
            case 3: {
                x -= 16;
                z += 0;
                dir = 2;
                break;
            }
            case 4: {
                x += 0;
                z -= 16;
                dir = 3;
            }
        }
        return this.generateNextRoom(world, random, new PositionData(x, y, z), dir);
    }

    public boolean generateNextRoom(World world, Random random, PositionData pos, int dir) {
        int z;
        int y;
        int x = pos.getX();
        if (!this.isBoxSolid(world, new PositionData(x, y = pos.getY(), z = pos.getZ()), new PositionData(12, 8, 12)) || this.isSpaceTaken(world, new PositionData(x, y, z), new PositionData(12, 8, 12))) {
            return false;
        }
        this.setBlocks(this.mainBlock(), this.mainLightBlock(), 20);
        this.addHollowBox(world, random, new PositionData(x, y, z), new PositionData(12, 8, 12));
        for (int p = x + 2; p < x + 10; p += 7) {
            for (int q = z + 2; q < z + 10; q += 7) {
                if (this.placementStorage.get(new BlockPos.MutableBlockPos().func_181079_c(p, pos.getY(), q)) == Blocks.field_150350_a || this.placementStorage.get(new BlockPos.MutableBlockPos().func_181079_c(p, pos.getY(), q)) == null) continue;
                this.storeReplacementBlock(world, new BlockPos(p, pos.getY(), q), BlocksAether.dungeon_trap.func_176223_P());
            }
        }
        this.addPlaneY(world, random, new PositionData(x + 4, y + 1, z + 4), new PositionData(4, 0, 4));
        int type = random.nextInt(2);
        int p = x + 5 + random.nextInt(2);
        int q = z + 5 + random.nextInt(2);
        switch (type) {
            case 0: {
                this.storeReplacementBlock(world, new BlockPos(p, y + 2, q), BlocksAether.chest_mimic.func_176223_P());
                break;
            }
            case 1: {
                this.storeReplacementBlock(world, new BlockPos(p, y + 2, q), BlocksAether.dungeon_chest.func_176223_P());
            }
        }
        this.setBlocks(this.fillerBlock(), this.fillerBlock1(), 5);
        switch (dir) {
            case 0: {
                this.addSquareTube(world, random, new PositionData(x - 5, y, z + 3), new PositionData(6, 6, 6), 0);
                break;
            }
            case 1: {
                this.addSquareTube(world, random, new PositionData(x + 3, y, z - 5), new PositionData(6, 6, 6), 2);
                break;
            }
            case 2: {
                this.addSquareTube(world, random, new PositionData(x + 11, y, z + 3), new PositionData(6, 6, 6), 0);
                break;
            }
            case 3: {
                this.addSquareTube(world, random, new PositionData(x + 3, y, z + 11), new PositionData(6, 6, 6), 2);
            }
        }
        ++this.roomCount;
        if (!this.determineRoomPosition(world, random, new PositionData(x, y, z))) {
            return false;
        }
        return this.determineRoomPosition(world, random, new PositionData(x, y, z));
    }

    public boolean endCorridor(World world, Random random, PositionData pos) {
        ArrayList<Integer> sides = new ArrayList<Integer>();
        sides.add(1);
        sides.add(2);
        sides.add(3);
        sides.add(4);
        Collections.shuffle(sides);
        if (this.generateEndCorridor(world, random, pos, (Integer)sides.get(0))) {
            return true;
        }
        if (this.generateEndCorridor(world, random, pos, (Integer)sides.get(1))) {
            return true;
        }
        if (this.generateEndCorridor(world, random, pos, (Integer)sides.get(2))) {
            return true;
        }
        return this.generateEndCorridor(world, random, pos, (Integer)sides.get(3));
    }

    public boolean generateEndCorridor(World world, Random random, PositionData pos, int switchCase) {
        if (!this.needsCorridor) {
            return false;
        }
        switch (switchCase) {
            case 1: {
                boolean tunnelling = true;
                boolean maxLength = false;
                int x = pos.getX();
                int y = pos.getY();
                int z = pos.getZ();
                if (this.isSpaceTaken(world, new PositionData((x += 11) + 1, y, z += 3), new PositionData(2, 8, 6))) {
                    return false;
                }
                while (tunnelling) {
                    if (this.isBoxEmpty(world, new PositionData(x, y, z), new PositionData(1, 8, 6))) {
                        tunnelling = false;
                    }
                    if (x - pos.getX() > 100) {
                        maxLength = true;
                        tunnelling = false;
                    }
                    if (x == pos.getX() + 11) {
                        this.setBlocks(this.fillerBlock(), this.fillerBlock1(), 5);
                        this.addPlaneX(world, random, new PositionData(x, y, z), new PositionData(0, 8, 6));
                        this.setBlocks(Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), 1);
                        this.addPlaneX(world, random, new PositionData(x, y + 1, z + 1), new PositionData(0, 6, 4));
                    }
                    this.setBlocks(this.fillerBlock(), this.fillerBlock1(), 5);
                    this.addTunnelPlaneX(world, random, new PositionData(x, y, z), new PositionData(0, 8, 6));
                    this.setBlocks(Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), 1);
                    this.addTunnelPlaneX(world, random, new PositionData(x, y + 1, z + 1), new PositionData(0, 6, 4));
                    ++x;
                }
                if (maxLength) {
                    return false;
                }
                this.needsCorridor = false;
                return true;
            }
            case 2: {
                boolean tunnelling = true;
                boolean maxLength = false;
                int x = pos.getX();
                int y = pos.getY();
                int z = pos.getZ();
                if (this.isSpaceTaken(world, new PositionData((x += 0) - 1, y, z += 3), new PositionData(1, 8, 6))) {
                    return false;
                }
                while (tunnelling) {
                    if (this.isBoxEmpty(world, new PositionData(x, y, z), new PositionData(1, 8, 6))) {
                        tunnelling = false;
                    }
                    if (pos.getX() - x > 100) {
                        maxLength = true;
                        tunnelling = false;
                    }
                    if (x == pos.getX()) {
                        this.setBlocks(this.fillerBlock(), this.fillerBlock1(), 5);
                        this.addPlaneX(world, random, new PositionData(x, y, z), new PositionData(0, 8, 6));
                        this.setBlocks(Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), 1);
                        this.addPlaneX(world, random, new PositionData(x, y + 1, z + 1), new PositionData(0, 6, 4));
                    }
                    this.setBlocks(this.fillerBlock(), this.fillerBlock1(), 5);
                    this.addTunnelPlaneX(world, random, new PositionData(x, y, z), new PositionData(0, 8, 6));
                    this.setBlocks(Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), 1);
                    this.addTunnelPlaneX(world, random, new PositionData(x, y + 1, z + 1), new PositionData(0, 6, 4));
                    --x;
                }
                if (maxLength) {
                    return false;
                }
                this.needsCorridor = false;
                return true;
            }
            case 3: {
                boolean tunnelling = true;
                boolean maxLength = false;
                int x = pos.getX();
                int y = pos.getY();
                int z = pos.getZ();
                if (this.isSpaceTaken(world, new PositionData(x += 3, y, (z += 11) + 1), new PositionData(6, 8, 2))) {
                    return false;
                }
                while (tunnelling) {
                    if (this.isBoxEmpty(world, new PositionData(x, y, z), new PositionData(6, 8, 1))) {
                        tunnelling = false;
                    }
                    if (z - pos.getZ() > 100) {
                        maxLength = true;
                        tunnelling = false;
                    }
                    if (z == pos.getZ() + 11) {
                        this.setBlocks(this.fillerBlock(), this.fillerBlock1(), 5);
                        this.addPlaneZ(world, random, new PositionData(x, y, z), new PositionData(6, 8, 0));
                        this.setBlocks(Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), 1);
                        this.addPlaneZ(world, random, new PositionData(x + 1, y + 1, z), new PositionData(4, 6, 0));
                    }
                    this.setBlocks(this.fillerBlock(), this.fillerBlock1(), 5);
                    this.addTunnelPlaneZ(world, random, new PositionData(x, y, z), new PositionData(6, 8, 0));
                    this.setBlocks(Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), 1);
                    this.addTunnelPlaneZ(world, random, new PositionData(x + 1, y + 1, z), new PositionData(4, 6, 0));
                    ++z;
                }
                if (maxLength) {
                    return false;
                }
                this.needsCorridor = false;
                return true;
            }
            case 4: {
                boolean tunnelling = true;
                boolean maxLength = false;
                int x = pos.getX();
                int y = pos.getY();
                int z = pos.getZ();
                if (this.isSpaceTaken(world, new PositionData(x += 3, y, (z += 0) - 1), new PositionData(6, 8, 1))) {
                    return false;
                }
                while (tunnelling) {
                    if (this.isBoxEmpty(world, new PositionData(x, y, z), new PositionData(6, 8, 1))) {
                        tunnelling = false;
                    }
                    if (pos.getZ() - z > 100) {
                        maxLength = true;
                        tunnelling = false;
                    }
                    if (z == pos.getZ()) {
                        this.setBlocks(this.fillerBlock(), this.fillerBlock1(), 5);
                        this.addPlaneZ(world, random, new PositionData(x, y, z), new PositionData(6, 8, 0));
                        this.setBlocks(Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), 1);
                        this.addPlaneZ(world, random, new PositionData(x + 1, y + 1, z), new PositionData(4, 6, 0));
                    }
                    this.setBlocks(this.fillerBlock(), this.fillerBlock1(), 5);
                    this.addTunnelPlaneZ(world, random, new PositionData(x, y, z), new PositionData(6, 8, 0));
                    this.setBlocks(Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), 1);
                    this.addTunnelPlaneZ(world, random, new PositionData(x + 1, y + 1, z), new PositionData(4, 6, 0));
                    --z;
                }
                if (maxLength) {
                    return false;
                }
                this.needsCorridor = false;
                return true;
            }
        }
        return false;
    }

    public IBlockState lockedLightBlock() {
        return BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Sentry));
    }

    public IBlockState lockedBlock() {
        return BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Carved));
    }

    public IBlockState mainLightBlock() {
        return BlocksAether.dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Sentry));
    }

    public IBlockState mainBlock() {
        return BlocksAether.dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Carved));
    }

    public IBlockState fillerBlock() {
        return BlocksAether.holystone.func_176223_P().func_177226_a((IProperty)BlockHolystone.dungeon_block, (Comparable)Boolean.valueOf(true));
    }

    public IBlockState fillerBlock1() {
        return BlocksAether.mossy_holystone.func_176223_P().func_177226_a((IProperty)BlockHolystone.dungeon_block, (Comparable)Boolean.valueOf(true));
    }
}

