/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.network;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import wanion.lib.WanionLib;
import wanion.lib.common.ICopyable;
import wanion.lib.common.control.IControl;
import wanion.lib.common.control.IControlContainer;
import wanion.lib.common.control.IControlControllerProvider;
import wanion.lib.common.field.FieldController;
import wanion.lib.common.field.IField;
import wanion.lib.common.field.IFieldContainer;
import wanion.lib.common.field.IFieldControllerProvider;
import wanion.lib.common.matching.AbstractMatching;
import wanion.lib.common.matching.IMatchingContainer;
import wanion.lib.common.matching.IMatchingControllerProvider;
import wanion.lib.common.matching.MatchingController;
import wanion.lib.network.SmartNBTMessage;

public class NetworkHelper {
    private NetworkHelper() {
    }

    public static void addControlListener(int windowId, @Nonnull IControlControllerProvider controlControllerProvider, @Nonnull EntityPlayerMP entityPlayerMP) {
        NBTTagCompound smartNBT = new NBTTagCompound();
        NBTTagList controlTagList = new NBTTagList();
        smartNBT.func_74782_a("control", (NBTBase)controlTagList);
        controlControllerProvider.getControlController().getInstances().forEach(control -> controlTagList.func_74742_a((NBTBase)control.writeNBT()));
        WanionLib.networkWrapper.sendTo((IMessage)new SmartNBTMessage(windowId, smartNBT), entityPlayerMP);
    }

    public static void detectAndSendControlChanges(int windowId, @Nonnull IControlContainer controlContainer) {
        List<IControl<?>> controlList = controlContainer.getControlController().compareContents(controlContainer.getContainerControlController());
        if (!controlList.isEmpty()) {
            controlContainer.getContainerControlController().forceAdd(controlList.stream().map(ICopyable::copy).collect(Collectors.toList()));
            NBTTagCompound smartNBT = new NBTTagCompound();
            NBTTagList controlTagList = new NBTTagList();
            smartNBT.func_74782_a("control", (NBTBase)controlTagList);
            controlList.forEach(control -> controlTagList.func_74742_a((NBTBase)control.writeNBT()));
            for (IContainerListener containerListener : controlContainer.getListeners()) {
                if (!(containerListener instanceof EntityPlayerMP)) continue;
                WanionLib.networkWrapper.sendTo((IMessage)new SmartNBTMessage(windowId, smartNBT), (EntityPlayerMP)containerListener);
            }
        }
    }

    public static void addFieldListener(int windowId, @Nonnull IFieldControllerProvider fieldControllerProvider, @Nonnull EntityPlayerMP entityPlayerMP) {
        NBTTagCompound smartNBT = new NBTTagCompound();
        NBTTagList fieldTagList = new NBTTagList();
        smartNBT.func_74782_a("field", (NBTBase)fieldTagList);
        fieldControllerProvider.getFieldController().getInstances().forEach(field -> fieldTagList.func_74742_a((NBTBase)field.writeNBT()));
        WanionLib.networkWrapper.sendTo((IMessage)new SmartNBTMessage(windowId, smartNBT), entityPlayerMP);
    }

    public static void detectAndSendFieldChanges(int windowId, @Nonnull IFieldContainer fieldContainer) {
        List<IField<?>> fieldList = fieldContainer.getFieldController().compareContents(fieldContainer.getContainerFieldController());
        if (!fieldList.isEmpty()) {
            fieldList.stream().map(ICopyable::copy).collect(Collectors.toList()).forEach(arg_0 -> NetworkHelper.lambda$detectAndSendFieldChanges$3(fieldContainer.getContainerFieldController(), arg_0));
            NBTTagCompound smartNBT = new NBTTagCompound();
            NBTTagList fieldTag = new NBTTagList();
            smartNBT.func_74782_a("field", (NBTBase)fieldTag);
            fieldList.forEach(field -> fieldTag.func_74742_a((NBTBase)field.writeNBT()));
            for (IContainerListener containerListener : fieldContainer.getListeners()) {
                if (!(containerListener instanceof EntityPlayerMP)) continue;
                WanionLib.networkWrapper.sendTo((IMessage)new SmartNBTMessage(windowId, smartNBT), (EntityPlayerMP)containerListener);
            }
        }
    }

    public static void addMatchingListener(int windowId, @Nonnull IMatchingControllerProvider matchingControllerProvider, @Nonnull EntityPlayerMP entityPlayerMP) {
        NBTTagCompound smartNBT = new NBTTagCompound();
        NBTTagList fieldTagList = new NBTTagList();
        smartNBT.func_74782_a("matching", (NBTBase)fieldTagList);
        matchingControllerProvider.getMatchingController().getInstances().forEach(matching -> fieldTagList.func_74742_a((NBTBase)matching.writeNBT()));
        WanionLib.networkWrapper.sendTo((IMessage)new SmartNBTMessage(windowId, smartNBT), entityPlayerMP);
    }

    public static void detectAndSendMatchingChanges(int windowId, @Nonnull IMatchingContainer matchingContainer) {
        List<AbstractMatching<?>> matchingList = matchingContainer.getMatchingController().compareContents(matchingContainer.getContainerMatchingController());
        if (!matchingList.isEmpty()) {
            matchingList.stream().map(ICopyable::copy).collect(Collectors.toList()).forEach(arg_0 -> NetworkHelper.lambda$detectAndSendMatchingChanges$6(matchingContainer.getContainerMatchingController(), arg_0));
            NBTTagCompound smartNBT = new NBTTagCompound();
            NBTTagList matchingTag = new NBTTagList();
            smartNBT.func_74782_a("matching", (NBTBase)matchingTag);
            matchingList.forEach(matching -> matchingTag.func_74742_a((NBTBase)matching.writeNBT()));
            for (IContainerListener containerListener : matchingContainer.getListeners()) {
                if (!(containerListener instanceof EntityPlayerMP)) continue;
                WanionLib.networkWrapper.sendTo((IMessage)new SmartNBTMessage(windowId, smartNBT), (EntityPlayerMP)containerListener);
            }
        }
    }

    private static /* synthetic */ void lambda$detectAndSendMatchingChanges$6(MatchingController rec$, AbstractMatching xva$0) {
        rec$.add(xva$0);
    }

    private static /* synthetic */ void lambda$detectAndSendFieldChanges$3(FieldController rec$, IField xva$0) {
        rec$.add(xva$0);
    }
}

