/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.advancements.criterion.data;

import com.bloodnbonesgaming.lib.util.data.BlockPredicate;
import com.bloodnbonesgaming.lib.util.data.ItemBlockData;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.CriterionTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.trigger.EnterBlockTriggerInstanceExtended;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.critereon.MinMaxBounds;

@ScriptClassDocumentation(documentationFile="./config/triumph/documentation/criteria/triggers/minecraft/enter_block", classExplaination="These are the functions which can be called on a minecraft:enter_block criteria trigger.")
public class EnterBlockTriggerData
extends CriterionTriggerData {
    BlockPredicate blockPredicate = BlockPredicate.ANY;
    private final ItemBlockData blockData = new ItemBlockData();

    public EnterBlockTriggerData(String criterionName, String advancementName) {
        super(criterionName, advancementName);
    }

    @Override
    public Criterion buildCriterion() throws Exception {
        BlockPredicate block = this.blockPredicate == BlockPredicate.ANY ? this.blockData.buildBlockPredicate() : this.blockPredicate;
        return new Criterion((ICriterionInstance)new EnterBlockTriggerInstanceExtended(block));
    }

    @ScriptMethodDocumentation(args="ItemBlockData", usage="block data", notes="Sets the required block.")
    public void setBlock(ItemBlockData data) throws Exception {
        this.blockPredicate = data.buildBlockPredicate();
    }

    public ItemBlockData getBlock() {
        return this.blockData;
    }

    public void setBlock(String blockName) {
        this.setBlock(blockName, null);
    }

    public void setBlock(String blockName, Integer meta) {
        this.blockData.setLocation(blockName);
        this.blockData.setMeta(meta != null ? new MinMaxBounds(Float.valueOf(meta.floatValue()), Float.valueOf(meta.floatValue())) : MinMaxBounds.field_192516_a);
    }

    public void setOreDict(String oreDict) throws Exception {
        this.blockData.setOre(oreDict);
    }
}

