/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tips;

import java.lang.reflect.Field;
import net.darkhax.tips.TipsAPI;
import net.darkhax.tips.TipsMod;
import net.darkhax.tips.client.shader.WrappedFrameBuffer;
import net.minecraft.client.LoadingScreenRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiDisconnected;
import net.minecraft.client.gui.GuiDownloadTerrain;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenWorking;
import net.minecraft.client.multiplayer.GuiConnecting;
import net.minecraft.client.shader.Framebuffer;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="tips")
public class TipHandler {
    private static final Field bufferField = ReflectionHelper.findField(LoadingScreenRenderer.class, (String[])new String[]{"field_146588_g", "framebuffer"});
    private static int prevWidth = 0;
    private static int prevHeight = 0;

    @SubscribeEvent
    public static void onGuiInit(GuiScreenEvent.InitGuiEvent event) {
        TipsAPI.getRandomTip();
    }

    @SubscribeEvent
    public static void onGuiDraw(GuiScreenEvent.DrawScreenEvent event) {
        GuiScreen gui = event.getGui();
        if (gui instanceof GuiScreenWorking || gui instanceof GuiDownloadTerrain || gui instanceof GuiConnecting || gui instanceof GuiDisconnected) {
            TipsAPI.renderTip();
        }
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71443_c != prevWidth || mc.field_71440_d != prevHeight) {
            try {
                Framebuffer delegate = (Framebuffer)bufferField.get(mc.field_71461_s);
                WrappedFrameBuffer wrapped = new WrappedFrameBuffer(delegate);
                bufferField.set(mc.field_71461_s, (Object)wrapped);
                prevWidth = mc.field_71443_c;
                prevHeight = mc.field_71440_d;
                TipsMod.LOG.info("Window size change detected! World loading screen hooks have been reapplied.");
            }
            catch (Exception e) {
                TipsMod.LOG.error("An error occured while trying to hook into the world loading screen!");
                TipsMod.LOG.catching((Throwable)e);
            }
        }
    }
}

