/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.thaumicjei.category;

import com.buuz135.thaumicjei.ThaumcraftJEIPlugin;
import com.buuz135.thaumicjei.category.IHasResearch;
import com.buuz135.thaumicjei.drawable.AlphaDrawable;
import com.buuz135.thaumicjei.drawable.ItemStackDrawable;
import com.buuz135.thaumicjei.ingredient.AspectIngredientRender;
import com.buuz135.thaumicjei.util.ResearchUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.crafting.InfusionRecipe;

public class InfusionCategory
implements IRecipeCategory<InfusionWrapper> {
    public static final String UUID = "THAUMCRAFT_INFUSION";
    public static final int ASPECT_Y = 135;
    public static final int ASPECT_X = 46;
    public static final int SPACE = 22;

    public String getUid() {
        return UUID;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"thaumicjei.category.infusion.title", (Object[])new Object[0]);
    }

    public String getModName() {
        return "ThaumicJEI";
    }

    public IDrawable getBackground() {
        return new AlphaDrawable(new ResourceLocation("thaumcraft", "textures/gui/gui_researchbook_overlay.png"), 413, 154, 86, 86, 40, 44, 30, 30);
    }

    public void drawExtras(Minecraft minecraft) {
        minecraft.field_71446_o.func_110577_a(new ResourceLocation("thaumcraft", "textures/gui/gui_researchbook_overlay.png"));
        GL11.glEnable((int)3042);
        Gui.func_146110_a((int)57, (int)0, (float)40.0f, (float)6.0f, (int)32, (int)32, (float)512.0f, (float)512.0f);
        GL11.glDisable((int)3042);
    }

    @Nullable
    public IDrawable getIcon() {
        return new ItemStackDrawable(new ItemStack(Block.func_149684_b((String)new ResourceLocation("thaumcraft", "infusion_matrix").toString())));
    }

    public void setRecipe(IRecipeLayout recipeLayout, InfusionWrapper recipeWrapper, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, false, 64, 7);
        recipeLayout.getItemStacks().set(0, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        int slot = 1;
        float currentRotation = -90.0f;
        for (List stacks : ingredients.getInputs(VanillaTypes.ITEM)) {
            if (slot == 1) {
                recipeLayout.getItemStacks().init(slot, true, 64, 75);
            } else {
                recipeLayout.getItemStacks().init(slot, true, 30 + (int)(MathHelper.func_76134_b((float)((float)((double)(currentRotation / 180.0f) * Math.PI))) * 40.0f) + 34, (int)(MathHelper.func_76126_a((float)(currentRotation / 180.0f * (float)Math.PI)) * 40.0f) + 75);
            }
            recipeLayout.getItemStacks().set(slot, stacks);
            currentRotation += 360.0f / (float)recipeWrapper.recipe.getComponents().size();
            ++slot;
        }
        int center = ingredients.getInputs(ThaumcraftJEIPlugin.ASPECT_LIST).size() * 22 / 2;
        int x = 0;
        for (List aspectList : ingredients.getInputs(ThaumcraftJEIPlugin.ASPECT_LIST)) {
            recipeLayout.getIngredientsGroup(ThaumcraftJEIPlugin.ASPECT_LIST).init(x + slot, true, (IIngredientRenderer)new AspectIngredientRender(), 76 - center + x * 22, 135, 16, 16, 0, 0);
            recipeLayout.getIngredientsGroup(ThaumcraftJEIPlugin.ASPECT_LIST).set(x + slot, aspectList);
            ++x;
        }
    }

    public static class InfusionWrapper
    implements IHasResearch,
    IRecipeWrapper {
        private final InfusionRecipe recipe;

        public InfusionWrapper(InfusionRecipe recipe) {
            this.recipe = recipe;
        }

        public void getIngredients(IIngredients ingredients) {
            ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
            inputs.add(Arrays.asList(this.recipe.getRecipeInput().func_193365_a()));
            if (this.recipe.recipeOutput instanceof ItemStack) {
                ingredients.setOutput(VanillaTypes.ITEM, (Object)((ItemStack)this.recipe.recipeOutput).func_77946_l());
            } else if (this.recipe.recipeOutput != null) {
                for (ItemStack stack : (List)inputs.get(0)) {
                    if (stack == null) continue;
                    Object[] objects = (Object[])this.recipe.recipeOutput;
                    ItemStack copied = stack.func_77946_l();
                    copied.func_77983_a((String)objects[0], (NBTBase)objects[1]);
                    ingredients.setOutput(VanillaTypes.ITEM, (Object)copied);
                }
            }
            for (Ingredient comp : this.recipe.getComponents()) {
                inputs.add(Arrays.asList(comp.func_193365_a()));
            }
            ingredients.setInputLists(VanillaTypes.ITEM, inputs);
            ingredients.setInputs(ThaumcraftJEIPlugin.ASPECT_LIST, Arrays.stream(this.recipe.aspects.getAspectsSortedByAmount()).map(aspect -> new AspectList().add(aspect, this.recipe.aspects.getAmount(aspect))).collect(Collectors.toList()));
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            int instability = Math.min(5, this.recipe.instability / 2);
            String inst = TextFormatting.DARK_GRAY + new TextComponentTranslation("tc.inst", new Object[0]).func_150254_d() + new TextComponentTranslation("tc.inst." + instability, new Object[0]).func_150260_c();
            minecraft.field_71466_p.func_78276_b(inst, recipeWidth / 2 - minecraft.field_71466_p.func_78256_a(inst) / 2, 158, 0);
            if (!ThaumcraftCapabilities.knowsResearch((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (String[])this.getResearch())) {
                minecraft.func_175599_af().func_175042_a(new ItemStack(Blocks.field_180401_cv), 92, 9);
            }
        }

        @Override
        public String[] getResearch() {
            return new String[]{this.recipe.research};
        }

        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            if (!ThaumcraftCapabilities.knowsResearch((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (String[])this.getResearch()) && mouseX > 92 && mouseX < 108 && mouseY > 9 && mouseY < 25) {
                return ResearchUtils.generateMissingResearchList(this.getResearch());
            }
            return null;
        }
    }
}

