/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.common.lib.SoundsTC;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.block.property.IHorizontallyDirectionalBlock;
import thecodex6824.thaumicaugmentation.api.tile.CapabilityRiftJar;
import thecodex6824.thaumicaugmentation.api.tile.IRiftJar;
import thecodex6824.thaumicaugmentation.common.block.prefab.BlockTABase;
import thecodex6824.thaumicaugmentation.common.tile.TileRiftJar;
import thecodex6824.thaumicaugmentation.common.util.BitUtil;

public class BlockRiftJar
extends BlockTABase
implements IHorizontallyDirectionalBlock {
    protected static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.1865, 0.0, 0.1875, 0.8125, 0.75, 0.8125);

    public BlockRiftJar() {
        super(Material.field_151592_s);
        this.func_149711_c(0.3f);
        this.func_149672_a(SoundsTC.JAR);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)IHorizontallyDirectionalBlock.DIRECTION, (Comparable)EnumFacing.SOUTH));
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        if (this.field_149762_H == null) {
            this.func_149672_a(SoundsTC.JAR);
        }
        return super.getSoundType(state, world, pos, entity);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IHorizontallyDirectionalBlock.DIRECTION});
    }

    public int func_176201_c(IBlockState state) {
        return BitUtil.setBits(0, 0, 2, ((EnumFacing)state.func_177229_b((IProperty)IHorizontallyDirectionalBlock.DIRECTION)).func_176736_b());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)IHorizontallyDirectionalBlock.DIRECTION, (Comparable)EnumFacing.func_176731_b((int)BitUtil.getBits(meta, 0, 2)));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)IHorizontallyDirectionalBlock.DIRECTION, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        IRiftJar rift;
        ItemStack jar = new ItemStack((Block)this);
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && (rift = (IRiftJar)tile.getCapability(CapabilityRiftJar.RIFT_JAR, null)) != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("seed", rift.getRift().getRiftSeed());
            tag.func_74768_a("size", rift.getRift().getRiftSize());
            jar.func_77982_d(tag);
        }
        drops.add((Object)jar);
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileRiftJar();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == TAItems.CREATIVE_TAB || tab == CreativeTabs.field_78027_g) {
            items.add((Object)new ItemStack((Block)this));
            ItemStack stack = new ItemStack((Block)this);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("seed", 1337);
            tag.func_74768_a("size", 100);
            stack.func_77982_d(tag);
            items.add((Object)stack);
        }
    }
}

