/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.entity;

import java.util.LinkedList;
import java.util.ListIterator;
import java.util.WeakHashMap;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import thecodex6824.thaumicaugmentation.api.TAConfig;

public final class PlayerMovementAbilityManager {
    private static WeakHashMap<EntityPlayer, FlyData> flyData = new WeakHashMap();
    private static WeakHashMap<EntityPlayer, OldMovementData> oldMovementValues = new WeakHashMap();
    private static WeakHashMap<EntityPlayer, LinkedList<PlayerFunctions>> players = new WeakHashMap();

    private PlayerMovementAbilityManager() {
    }

    public static boolean isValidSideForMovement(EntityPlayer player) {
        return player.func_130014_f_().field_72995_K || FMLCommonHandler.instance().getSide() == Side.SERVER && TAConfig.serverMovementCalculation.getValue() != false;
    }

    public static void put(EntityPlayer player, BiFunction<EntityPlayer, MovementType, Float> func, Predicate<EntityPlayer> continueApplying) {
        if (!oldMovementValues.containsKey(player)) {
            oldMovementValues.put(player, new OldMovementData(0.0f, 0.0f, player.field_71093_bK));
        }
        if (players.containsKey(player)) {
            players.get(player).add(new PlayerFunctions(func, continueApplying));
        } else {
            LinkedList<PlayerFunctions> newList = new LinkedList<PlayerFunctions>();
            newList.add(new PlayerFunctions(func, continueApplying));
            players.put(player, newList);
        }
    }

    public static boolean remove(EntityPlayer player, BiFunction<EntityPlayer, MovementType, Float> func, Predicate<EntityPlayer> pred) {
        boolean result = players.remove(player.func_189512_bd(), new PlayerFunctions(func, pred));
        if (players.containsKey(player) && players.get(player).size() == 0) {
            OldMovementData data = oldMovementValues.get(player);
            player.field_70138_W -= data.stepHeight;
            player.field_71102_ce -= data.speedInAir;
            players.remove(player);
            if (oldMovementValues.containsKey(player)) {
                oldMovementValues.remove(player);
            }
        }
        return result;
    }

    public static boolean playerHasAbility(EntityPlayer player, BiFunction<EntityPlayer, MovementType, Float> func, Predicate<EntityPlayer> pred) {
        return players.containsKey(player) && players.get(player).contains(new PlayerFunctions(func, pred));
    }

    private static boolean isPlayerMovingNotVertically(EntityPlayer player) {
        return player.field_191988_bg > 1.0E-4f || player.field_191988_bg < -1.0E-4f || player.field_70702_br > 0.0f || player.field_70702_br < -1.0E-4f;
    }

    private static void movePlayer(EntityPlayer player, float factor) {
        if ((player.field_191988_bg > 1.0E-4f || player.field_191988_bg < -1.0E-4f) && (player.field_70702_br > 0.0f || player.field_70702_br < -1.0E-4f)) {
            float normalized = (float)Math.sqrt(player.field_70702_br * player.field_70702_br + player.field_191988_bg * player.field_191988_bg);
            player.func_191958_b(factor * (Math.signum(player.field_70702_br) / (normalized > 1.0f ? normalized : 1.0f / normalized)), 0.0f, factor * (Math.signum(player.field_191988_bg) / (normalized > 1.0f ? normalized : 1.0f / normalized)), 1.0f);
        } else if (player.field_191988_bg > 1.0E-4f || player.field_191988_bg < -1.0E-4f) {
            player.func_191958_b(0.0f, 0.0f, factor * Math.signum(player.field_191988_bg), 1.0f);
        } else {
            player.func_191958_b(factor * Math.signum(player.field_70702_br), 0.0f, 0.0f, 1.0f);
        }
    }

    public static void tick(EntityPlayer player) {
        if (players.containsKey(player)) {
            OldMovementData data = oldMovementValues.get(player);
            boolean compat = TAConfig.movementCompat.getValue();
            if (!compat) {
                player.field_70138_W -= data.stepHeight;
                player.field_71102_ce -= data.speedInAir;
            }
            data.stepHeight = 0.0f;
            data.speedInAir = 0.0f;
            boolean didSomething = false;
            ListIterator it = players.get(player).listIterator();
            while (it.hasNext()) {
                PlayerFunctions func = (PlayerFunctions)it.next();
                if (!func.continueFunction.test(player)) {
                    it.remove();
                    if (!players.containsKey(player) || players.get(player).size() != 0 || !oldMovementValues.containsKey(player)) continue;
                    players.remove(player);
                    oldMovementValues.remove(player);
                    continue;
                }
                didSomething = true;
                data.stepHeight += func.tickFunction.apply(player, MovementType.STEP_HEIGHT).floatValue();
                data.speedInAir += func.tickFunction.apply(player, MovementType.JUMP_FACTOR).floatValue();
                if (player.field_70122_E && PlayerMovementAbilityManager.isPlayerMovingNotVertically(player)) {
                    PlayerMovementAbilityManager.movePlayer(player, func.tickFunction.apply(player, player.func_70090_H() ? MovementType.WATER_GROUND : MovementType.DRY_GROUND).floatValue());
                    continue;
                }
                if (!(player.field_191988_bg > 0.0f) || !player.func_70090_H()) continue;
                PlayerMovementAbilityManager.movePlayer(player, func.tickFunction.apply(player, MovementType.WATER_SWIM).floatValue());
            }
            if (!compat) {
                player.field_70138_W += data.stepHeight;
                player.field_71102_ce += data.speedInAir;
            } else if (didSomething) {
                player.field_70138_W = player.field_70131_O * 0.33333334f + data.stepHeight;
                player.field_71102_ce = 0.02f * (player.field_70131_O / 1.8f) + data.speedInAir;
            }
        }
    }

    public static void onJump(EntityPlayer player) {
        LinkedList<PlayerFunctions> funcs = players.get(player);
        if (funcs != null) {
            for (PlayerFunctions func : funcs) {
                player.field_70181_x += (double)func.tickFunction.apply(player, MovementType.JUMP_BEGIN).floatValue();
            }
        }
    }

    public static void onPlayerRecreation(EntityPlayer player) {
        OldMovementData data = oldMovementValues.get(player);
        if (data != null) {
            data.speedInAir = 0.0f;
            data.stepHeight = 0.0f;
        }
    }

    public static void recordFlyState(EntityPlayer player) {
        flyData.put(player, new FlyData(player.field_71075_bZ.field_75101_c, player.field_71075_bZ.field_75100_b, player.field_71075_bZ.func_75093_a()));
    }

    public static boolean popAndApplyFlyState(EntityPlayer player) {
        FlyData data = flyData.remove(player);
        if (data != null) {
            if (!player.func_184812_l_() && !player.func_175149_v()) {
                player.field_71075_bZ.field_75101_c = data.flyEnabled;
                player.field_71075_bZ.field_75100_b &= data.wasFlying;
            }
            player.field_71075_bZ.field_75096_f = data.flySpeed;
            player.func_71016_p();
            return true;
        }
        return false;
    }

    private static final class FlyData {
        public boolean flyEnabled;
        public boolean wasFlying;
        public float flySpeed;

        public FlyData(boolean e, boolean f, float s) {
            this.flyEnabled = e;
            this.wasFlying = f;
            this.flySpeed = s;
        }
    }

    private static final class OldMovementData {
        public float stepHeight;
        public float speedInAir;

        public OldMovementData(float s, float j, int d) {
            this.stepHeight = s;
            this.speedInAir = j;
        }
    }

    private static final class PlayerFunctions {
        public BiFunction<EntityPlayer, MovementType, Float> tickFunction;
        public Predicate<EntityPlayer> continueFunction;

        public PlayerFunctions(BiFunction<EntityPlayer, MovementType, Float> func, Predicate<EntityPlayer> pred) {
            this.tickFunction = func;
            this.continueFunction = pred;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PlayerFunctions) {
                PlayerFunctions func = (PlayerFunctions)obj;
                return this.tickFunction.equals(func.tickFunction) && this.continueFunction.equals(func.continueFunction);
            }
            return false;
        }

        public int hashCode() {
            int ret = 217;
            ret += this.tickFunction.hashCode();
            ret *= 31;
            return ret += this.continueFunction.hashCode();
        }
    }

    public static enum MovementType {
        DRY_GROUND,
        WATER_GROUND,
        WATER_SWIM,
        JUMP_BEGIN,
        JUMP_FACTOR,
        STEP_HEIGHT;

    }
}

