/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import net.minecraft.nbt.NBTTagCompound;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;

public class ToolNBT {
    public int durability;
    public int harvestLevel;
    public float attack;
    public float speed;
    public float attackSpeedMultiplier;
    public int modifiers;
    private final NBTTagCompound parent;

    public ToolNBT() {
        this.durability = 0;
        this.harvestLevel = 0;
        this.attack = 0.0f;
        this.speed = 0.0f;
        this.attackSpeedMultiplier = 1.0f;
        this.modifiers = 3;
        this.parent = new NBTTagCompound();
    }

    public ToolNBT(NBTTagCompound tag) {
        this.read(tag);
        this.parent = tag;
    }

    public ToolNBT head(HeadMaterialStats ... heads) {
        this.durability = 0;
        this.harvestLevel = 0;
        this.attack = 0.0f;
        this.speed = 0.0f;
        for (HeadMaterialStats head : heads) {
            if (head == null) continue;
            this.durability += head.durability;
            this.attack += head.attack;
            this.speed += head.miningspeed;
            if (head.harvestLevel <= this.harvestLevel) continue;
            this.harvestLevel = head.harvestLevel;
        }
        this.durability = Math.max(1, this.durability / heads.length);
        this.attack /= (float)heads.length;
        this.speed /= (float)heads.length;
        return this;
    }

    public ToolNBT extra(ExtraMaterialStats ... extras) {
        int dur = 0;
        for (ExtraMaterialStats extra : extras) {
            if (extra == null) continue;
            dur += extra.extraDurability;
        }
        this.durability += Math.round((float)dur / (float)extras.length);
        return this;
    }

    public ToolNBT handle(HandleMaterialStats ... handles) {
        int dur = 0;
        float modifier = 0.0f;
        for (HandleMaterialStats handle : handles) {
            if (handle == null) continue;
            dur += handle.durability;
            modifier += handle.modifier;
        }
        this.durability = Math.round((float)this.durability * (modifier /= (float)handles.length));
        this.durability += Math.round((float)dur / (float)handles.length);
        this.durability = Math.max(1, this.durability);
        return this;
    }

    public void read(NBTTagCompound tag) {
        this.durability = tag.func_74762_e("Durability");
        this.harvestLevel = tag.func_74762_e("HarvestLevel");
        this.attack = tag.func_74760_g("Attack");
        this.speed = tag.func_74760_g("MiningSpeed");
        this.attackSpeedMultiplier = tag.func_74760_g("AttackSpeedMultiplier");
        this.modifiers = tag.func_74762_e("FreeModifiers");
    }

    public void write(NBTTagCompound tag) {
        tag.func_74768_a("Durability", this.durability);
        tag.func_74768_a("HarvestLevel", this.harvestLevel);
        tag.func_74776_a("Attack", this.attack);
        tag.func_74776_a("MiningSpeed", this.speed);
        tag.func_74776_a("AttackSpeedMultiplier", this.attackSpeedMultiplier);
        tag.func_74768_a("FreeModifiers", this.modifiers);
    }

    public NBTTagCompound get() {
        NBTTagCompound tag = this.parent.func_74737_b();
        this.write(tag);
        return tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ToolNBT toolNBT = (ToolNBT)o;
        if (this.durability != toolNBT.durability) {
            return false;
        }
        if (this.harvestLevel != toolNBT.harvestLevel) {
            return false;
        }
        if (Float.compare(toolNBT.attack, this.attack) != 0) {
            return false;
        }
        if (Float.compare(toolNBT.speed, this.speed) != 0) {
            return false;
        }
        return this.modifiers == toolNBT.modifiers;
    }

    public int hashCode() {
        int result = this.durability;
        result = 31 * result + this.harvestLevel;
        result = 31 * result + (this.attack != 0.0f ? Float.floatToIntBits(this.attack) : 0);
        result = 31 * result + (this.speed != 0.0f ? Float.floatToIntBits(this.speed) : 0);
        result = 31 * result + this.modifiers;
        return result;
    }
}

