/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class StateUtil {
    public static StateMatcher ANY = new StateMatcher("any");
    public static StateMatcher AIR = new StateMatcher("air");
    public static Map<Block, List<IProperty<?>>> skipProperties = new HashMap();

    public static void ignoreState(Block state, IProperty<?> property) {
        List thisProperty = skipProperties.computeIfAbsent(state, block -> new ArrayList());
        thisProperty.add(property);
    }

    public static boolean compareStates(IBlockState state1, IBlockState state2) {
        if (state1.func_177230_c() != state2.func_177230_c()) {
            return false;
        }
        ImmutableMap state1_props = state1.func_177228_b();
        ImmutableMap state2_props = state2.func_177228_b();
        if (state1_props.size() < state2_props.size()) {
            return false;
        }
        List skips = skipProperties.computeIfAbsent(state1.func_177230_c(), block -> new ArrayList());
        for (Map.Entry entry : state1_props.entrySet()) {
            if (skips.contains(entry.getKey())) continue;
            if (!state2_props.containsKey(entry.getKey())) {
                return false;
            }
            Comparable comp2 = (Comparable)state2_props.get(entry.getKey());
            if (((IProperty)entry.getKey()).func_177699_b().cast(entry.getValue()) == ((IProperty)entry.getKey()).func_177699_b().cast(comp2)) continue;
            return false;
        }
        return true;
    }

    public static boolean stateContainsValues(IBlockState stateBeingChecked, IBlockState stateWithValues) {
        if (stateBeingChecked.func_177230_c() != stateWithValues.func_177230_c()) {
            return false;
        }
        Collection keys = stateBeingChecked.func_177227_a();
        for (IProperty prop : stateWithValues.func_177227_a()) {
            if (!keys.contains(prop)) {
                return false;
            }
            if (stateBeingChecked.func_177229_b(prop) == stateWithValues.func_177229_b(prop)) continue;
            return false;
        }
        return true;
    }

    public static class StateMatcher
    implements Predicate<IBlockState> {
        private final String initial;
        private boolean invalid = false;
        private IBlockState state = null;
        private Predicate<IBlockState> tester = null;
        private final Predicate<IBlockState> air = s -> s.func_177230_c() == Blocks.field_150350_a;
        private final Predicate<IBlockState> any = s -> true;
        private Set<IProperty<?>> pairList = null;

        public IBlockState getState() {
            if (this.state == null) {
                this.state = this.calculateState();
            }
            return this.state;
        }

        public StateMatcher(String initial) {
            this.initial = initial.trim().toLowerCase(Locale.ROOT);
        }

        @Override
        public boolean test(IBlockState state) {
            if (this.invalid) {
                return false;
            }
            if (this.tester == null) {
                this.tester = this.calculateTester();
            }
            if (this.tester == null) {
                this.invalid = true;
                return false;
            }
            return this.tester.test(state);
        }

        private <T extends Comparable<T>> IBlockState findProperty(IBlockState baseState, IProperty<T> property, String keyName, String newValue) {
            if (keyName.equals(property.func_177701_a())) {
                for (Comparable value : property.func_177700_c()) {
                    if (!property.func_177702_a(value).equals(newValue)) continue;
                    this.pairList.add(property);
                    return baseState.func_177226_a(property, value);
                }
            }
            return null;
        }

        private Predicate<IBlockState> calculateTester() {
            if (this.initial.isEmpty()) {
                return null;
            }
            if (this.initial.equals("air")) {
                return this.air;
            }
            if (this.initial.equals("any")) {
                return this.any;
            }
            this.state = this.calculateState();
            if (this.state == null) {
                return null;
            }
            return new Matcher(this.pairList, this.state);
        }

        private IBlockState calculateState() {
            this.pairList = new HashSet();
            String[] split = this.initial.split("\\[");
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(split[0]));
            if (block != null) {
                IBlockState startingState = block.func_176223_P();
                if (split.length > 1) {
                    String[] split2;
                    for (String part : split2 = split[1].replace("]", "").split(",")) {
                        String[] pair = part.split("=");
                        if (pair.length != 2) continue;
                        for (IProperty property : startingState.func_177227_a()) {
                            IBlockState potential = this.findProperty(startingState, property, pair[0], pair[1]);
                            if (potential == null) continue;
                            startingState = potential;
                        }
                    }
                }
                return startingState;
            }
            return null;
        }

        private static class Matcher
        implements Predicate<IBlockState> {
            private final Set<IProperty<?>> props;
            private final IBlockState state;

            public Matcher(Set<IProperty<?>> props, IBlockState state) {
                this.props = props;
                this.state = state;
            }

            @Override
            public boolean test(IBlockState state) {
                if (this.state.func_177230_c() != state.func_177230_c()) {
                    return false;
                }
                ImmutableSet incomingStates = state.func_177228_b().keySet();
                for (IProperty<?> mine : this.props) {
                    if (!incomingStates.contains(mine)) {
                        return false;
                    }
                    if (this.state.func_177229_b(mine).equals(state.func_177229_b(mine))) continue;
                    return false;
                }
                return true;
            }
        }
    }
}

