/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.util;

import epicsquid.roots.entity.mob.EntityHuskSlave;
import epicsquid.roots.entity.mob.EntityPigZombieSlave;
import epicsquid.roots.entity.mob.EntityZombieSlave;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class SlaveUtil {
    private static Map<Class<?>, Function<World, EntityLivingBase>> slaveMap = new HashMap();
    private static Map<Class<?>, Function<World, EntityLivingBase>> reverseSlaveMap = new HashMap();

    public static boolean canBecomeSlave(Entity entity) {
        return entity != null && slaveMap.keySet().contains(entity.getClass());
    }

    public static boolean isSlave(Entity entity) {
        return entity != null && reverseSlaveMap.keySet().contains(entity.getClass());
    }

    public static EntityLivingBase enslave(EntityLivingBase parent) {
        return SlaveUtil.convert(slaveMap.get(parent.getClass()), parent);
    }

    public static EntityLivingBase revert(EntityLivingBase parent) {
        return SlaveUtil.convert(reverseSlaveMap.get(parent.getClass()), parent);
    }

    @Nullable
    public static EntityLivingBase convert(Function<World, EntityLivingBase> builder, EntityLivingBase parent) {
        if (parent.field_70170_p.field_72995_K) {
            return null;
        }
        EntityLivingBase slave = builder.apply(parent.field_70170_p);
        for (PotionEffect pot : parent.func_70651_bq()) {
            slave.func_70690_d(pot);
        }
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            slave.func_184201_a(slot, parent.func_184582_a(slot));
        }
        slave.func_70606_j(parent.func_110143_aJ());
        slave.field_70169_q = parent.field_70169_q;
        slave.field_70167_r = parent.field_70167_r;
        slave.field_70166_s = parent.field_70166_s;
        slave.field_70165_t = parent.field_70165_t;
        slave.field_70163_u = parent.field_70163_u;
        slave.field_70161_v = parent.field_70161_v;
        slave.field_70159_w = parent.field_70159_w;
        slave.field_70181_x = parent.field_70181_x;
        slave.field_70179_y = parent.field_70179_y;
        slave.field_70177_z = parent.field_70177_z;
        slave.field_70125_A = parent.field_70125_A;
        slave.field_70126_B = parent.field_70126_B;
        slave.field_70127_C = parent.field_70127_C;
        slave.field_70122_E = parent.field_70122_E;
        slave.field_70123_F = parent.field_70123_F;
        slave.field_70124_G = parent.field_70124_G;
        slave.field_70132_H = parent.field_70132_H;
        slave.field_70130_N = parent.field_70130_N;
        slave.field_70131_O = parent.field_70131_O;
        slave.field_70141_P = parent.field_70141_P;
        slave.field_70140_Q = parent.field_70140_Q;
        slave.field_82151_R = parent.field_82151_R;
        slave.field_70143_R = parent.field_70143_R;
        slave.field_70142_S = parent.field_70142_S;
        slave.field_70137_T = parent.field_70137_T;
        slave.field_70136_U = parent.field_70136_U;
        slave.field_70138_W = parent.field_70138_W;
        slave.field_70144_Y = parent.field_70144_Y;
        slave.field_70173_aa = parent.field_70173_aa;
        slave.field_70172_ad = parent.field_70172_ad;
        slave.field_70176_ah = parent.field_70176_ah;
        slave.field_70162_ai = parent.field_70162_ai;
        slave.field_70164_aj = parent.field_70164_aj;
        slave.field_71088_bW = parent.field_71088_bW;
        slave.field_71093_bK = parent.field_71093_bK;
        return slave;
    }

    static {
        slaveMap.put(EntityZombie.class, EntityZombieSlave::new);
        slaveMap.put(EntityHusk.class, EntityHuskSlave::new);
        slaveMap.put(EntityPigZombie.class, EntityPigZombieSlave::new);
        reverseSlaveMap.put(EntityZombieSlave.class, EntityZombie::new);
        reverseSlaveMap.put(EntityHuskSlave.class, EntityHusk::new);
        reverseSlaveMap.put(EntityPigZombieSlave.class, EntityPigZombie::new);
    }
}

