/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.tileentity;

import epicsquid.mysticallib.tile.TileBase;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.Roots;
import epicsquid.roots.advancements.Advancements;
import epicsquid.roots.container.ContainerImposer;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.item.ItemDruidKnife;
import epicsquid.roots.modifiers.IModifierCore;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstance;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.spell.info.StaffSpellInfo;
import epicsquid.roots.spell.info.storage.StaffSpellStorage;
import epicsquid.roots.util.SpellUtil;
import epicsquid.roots.world.data.SpellLibraryData;
import epicsquid.roots.world.data.SpellLibraryRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityImposer
extends TileBase
implements ITickable {
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityImposer.this.slot = 0;
            TileEntityImposer.this.func_70296_d();
            if (!((TileEntityImposer)TileEntityImposer.this).field_145850_b.field_72995_K) {
                TileEntityImposer.this.updatePacketViaState();
            }
        }
    };
    public int ticks = 0;
    public float angle = 0.0f;
    private int slot = 0;

    public int getSlot() {
        return this.slot;
    }

    public void updateInSlot(EntityPlayer player) {
        if (SpellUtil.isStaff(this.inventory.getStackInSlot(0))) {
            ItemStack staff = this.inventory.getStackInSlot(0);
            SpellUtil.updateModifiers(staff, player);
            this.inventory.setStackInSlot(0, staff);
            this.func_70296_d();
            this.updatePacketViaState();
        }
    }

    public void setSlot(int slot) {
        this.slot = slot;
        this.func_70296_d();
        this.updatePacketViaState();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("handler", (NBTBase)this.inventory.serializeNBT());
        tag.func_74768_a("slot", this.slot);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("handler"));
        this.slot = tag.func_74762_e("slot");
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean activate(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() == ModItems.staff) {
            if (this.inventory.getStackInSlot(0).func_190926_b()) {
                SpellUtil.updateModifiers(heldItem, player);
                ItemStack toInsert = heldItem.func_77946_l();
                toInsert.func_190920_e(1);
                ItemStack attemptedInsert = this.inventory.insertItem(0, toInsert, true);
                if (attemptedInsert.func_190926_b()) {
                    this.inventory.insertItem(0, toInsert, false);
                    player.func_184586_b(hand).func_190918_g(1);
                    if (player.func_184586_b(hand).func_190916_E() == 0) {
                        player.func_184611_a(hand, ItemStack.field_190927_a);
                    }
                    this.func_70296_d();
                    this.updatePacketViaState();
                    return true;
                }
            }
        } else {
            if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemDruidKnife) {
                ItemStack inSlot = this.inventory.getStackInSlot(0);
                if (inSlot.func_77973_b() == ModItems.staff && !world.field_72995_K) {
                    player.openGui((Object)Roots.instance, 19, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                return true;
            }
            if (heldItem.func_190926_b() && !world.field_72995_K && hand == EnumHand.MAIN_HAND) {
                for (int i = 0; i < this.inventory.getSlots(); ++i) {
                    if (!this.dropItemInInventory(this.inventory, i)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!world.field_72995_K) {
            Util.spawnInventoryInWorld((World)world, (double)((double)this.func_174877_v().func_177958_n() + 0.5), (double)((double)this.func_174877_v().func_177956_o() + 0.5), (double)((double)this.func_174877_v().func_177952_p() + 0.5), (IItemHandler)this.inventory);
        }
    }

    public StaffSpellInfo getCurrentInfo(StaffSpellStorage storage) {
        if (storage == null) {
            return StaffSpellInfo.EMPTY;
        }
        return storage.getSpellInSlot(this.slot);
    }

    @Nullable
    public StaffModifierInstance getModifier(StaffSpellStorage storage, IModifierCore core) {
        if (storage == null) {
            return null;
        }
        StaffSpellInfo info = storage.getSpellInSlot(this.slot);
        if (info == null) {
            return null;
        }
        StaffModifierInstanceList modifiers = info.getModifiers();
        return (StaffModifierInstance)modifiers.getByCore(core);
    }

    public void addModifier(IModifierCore core, ItemStack stack, ContainerImposer container) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            StaffSpellStorage storage = this.getSpellStorage();
            StaffModifierInstance modifier = this.getModifier(storage, core);
            if (modifier == null || storage == null) {
                return;
            }
            if (!ItemUtil.equalWithoutSize((ItemStack)modifier.getStack(), (ItemStack)stack)) {
                Roots.logger.error("Attempted to apply modifyCooldown core " + core + " to spell in slot " + this.slot + ", but it wants " + modifier.getStack() + " and we were passed " + stack + "!");
                return;
            }
            modifier.setApplied();
            storage.saveToStack();
            this.func_70296_d();
            this.updatePacketViaState();
            EntityPlayer player = container.getPlayer();
            Advancements.MODIFIER_TRIGGER.trigger((EntityPlayerMP)player, (Object)modifier.getModifier().getCore());
            SpellLibraryData data = SpellLibraryRegistry.getData(player);
            StaffSpellInfo info = storage.getSpellInSlot(this.slot);
            if (info == null) {
                throw new NullPointerException("StaffSpellInfo for applied modifier was somehow null");
            }
            data.updateSpell(info.toLibrary());
            SpellUtil.updateModifiers(player);
        }
    }

    @Nullable
    public StaffSpellStorage getSpellStorage() {
        ItemStack staff = this.inventory.getStackInSlot(0);
        if (staff.func_190926_b()) {
            return null;
        }
        return StaffSpellStorage.fromStack(staff);
    }

    public void func_73660_a() {
        ++this.ticks;
    }
}

