/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.ritual;

import epicsquid.mysticalworld.init.ModItems;
import epicsquid.roots.entity.ritual.EntityRitualPurity;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.properties.Property;
import epicsquid.roots.ritual.RitualBase;
import epicsquid.roots.ritual.conditions.ConditionRunedPillars;
import epicsquid.roots.util.RitualUtil;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class RitualPurity
extends RitualBase {
    public static Property.PropertyDuration PROP_DURATION = new Property.PropertyDuration(1200);
    public static Property<Integer> PROP_RADIUS_X = new Property<Integer>("radius_x", 15).setDescription("Radius on the X Axis of the cube in which the ritual takes place");
    public static Property<Integer> PROP_RADIUS_Y = new Property<Integer>("radius_y", 15).setDescription("Radius on the Y Axis of the cube in which the ritual takes place");
    public static Property<Integer> PROP_RADIUS_Z = new Property<Integer>("radius_z", 15).setDescription("Radius on the Z Axis of the cube in which the ritual takes place");
    public static Property.PropertyInterval PROP_INTERVAL = new Property.PropertyInterval(20).setDescription("interval in ticks between each purification or conversion boost");
    public static Property<Integer> PROP_ZOMBIE_COUNT = new Property<Integer>("zombie_count", 1).setDescription("the rate at which the zombie villager is converted back to a villager");
    public double radius_x;
    public double radius_y;
    public double radius_z;
    public int interval;
    public int zombie_count;

    public RitualPurity(String name, boolean disabled) {
        super(name, disabled);
        this.properties.add(PROP_DURATION, PROP_RADIUS_X, PROP_RADIUS_Y, PROP_RADIUS_Z, PROP_INTERVAL, PROP_ZOMBIE_COUNT);
        this.setEntityClass(EntityRitualPurity.class);
    }

    @Override
    public void init() {
        this.recipe = new RitualBase.RitualRecipe((RitualBase)this, new ItemStack(epicsquid.roots.init.ModItems.terra_moss), new ItemStack(ModItems.aubergine), new ItemStack(ModBlocks.baffle_cap_mushroom), new ItemStack(Items.field_151117_aB), new ItemStack(Items.field_151069_bo));
        this.addCondition(new ConditionRunedPillars(RitualUtil.RunedWoodType.OAK, 3, 2));
        this.setIcon(epicsquid.roots.init.ModItems.ritual_purity);
        this.setColor(TextFormatting.LIGHT_PURPLE);
        this.setBold(true);
    }

    @Override
    public void doFinalise() {
        this.duration = this.properties.get(PROP_DURATION);
        int[] radius = this.properties.getRadius();
        this.radius_x = (double)radius[0] + 0.5;
        this.radius_y = (double)radius[1] + 0.5;
        this.radius_z = (double)radius[2] + 0.5;
        this.interval = this.properties.get(PROP_INTERVAL);
        this.zombie_count = this.properties.get(PROP_ZOMBIE_COUNT);
    }
}

