/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.modifiers.instance.base;

import epicsquid.roots.api.Herb;
import epicsquid.roots.modifiers.BaseModifiers;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.IModifier;
import epicsquid.roots.modifiers.IModifierCore;
import epicsquid.roots.modifiers.IModifierCost;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.ModifierRegistry;
import epicsquid.roots.properties.Property;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.util.types.RegistryItem;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BaseModifierInstance
extends RegistryItem
implements INBTSerializable<NBTTagCompound>,
IModifier {
    protected Modifier modifier;
    protected boolean applied;

    protected BaseModifierInstance(Modifier modifier, boolean applied) {
        this.modifier = modifier;
        this.applied = applied;
    }

    protected BaseModifierInstance() {
        this.modifier = null;
        this.applied = false;
    }

    @Override
    public boolean isDisabled() {
        return this.modifier != null && this.modifier.isDisabled();
    }

    @Override
    public Modifier getModifier() {
        return this.modifier;
    }

    public boolean isApplied() {
        return this.applied && !this.isDisabled();
    }

    public void setApplied() {
        this.applied = true;
    }

    @Override
    public String getIdentifier() {
        return this.modifier.getIdentifier();
    }

    @Override
    public String getTranslationKey() {
        return this.modifier.getTranslationKey();
    }

    @Override
    public String getFormatting() {
        return this.modifier.getFormatting();
    }

    @SideOnly(value=Side.CLIENT)
    public String describe() {
        if (GuiScreen.func_146272_n()) {
            return this.getFormatting() + I18n.func_135052_a((String)this.getTranslationKey(), (Object[])new Object[0]) + TextFormatting.GRAY + ": " + I18n.func_135052_a((String)(this.getTranslationKey() + ".desc"), (Object[])new Object[0]);
        }
        return this.getFormatting() + I18n.func_135052_a((String)this.getTranslationKey(), (Object[])new Object[0]) + TextFormatting.RESET;
    }

    @SideOnly(value=Side.CLIENT)
    public String describeName() {
        return this.getFormatting() + I18n.func_135052_a((String)this.getTranslationKey(), (Object[])new Object[0]) + TextFormatting.GRAY + ":";
    }

    @SideOnly(value=Side.CLIENT)
    public String describeFunction() {
        return "- " + I18n.func_135052_a((String)(this.getTranslationKey() + ".desc"), (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> describeCost() {
        ArrayList<String> result = new ArrayList<String>();
        for (IModifierCost cost : this.modifier.getCosts().values()) {
            switch (cost.getCost()) {
                case NO_COST: {
                    result.add(I18n.func_135052_a((String)"roots.tooltip.modifier.no_cost", (Object[])new Object[0]));
                    break;
                }
                case ADDITIONAL_COST: {
                    if (cost.getHerb() == null) {
                        throw new NullPointerException("Additional herb modifier cost type but no herb specified.");
                    }
                    result.add(I18n.func_135052_a((String)"roots.tooltip.modifier.additional_cost", (Object[])new Object[]{I18n.func_135052_a((String)(cost.getHerb().getStack().func_77977_a() + ".name"), (Object[])new Object[0]), String.format("%.4f", cost.getValue())}));
                    break;
                }
                case ALL_COST_MULTIPLIER: {
                    if (cost.getValue() < 0.0) {
                        result.add(I18n.func_135052_a((String)"roots.tooltip.modifier.decreased_cost", (Object[])new Object[]{Math.floor(cost.getValue() * 100.0) + "%"}));
                        break;
                    }
                    result.add(I18n.func_135052_a((String)"roots.tooltip.modifier.increased_cost", (Object[])new Object[]{Math.floor(cost.getValue() * 100.0) + "%"}));
                    break;
                }
                case SPECIFIC_COST_ADJUSTMENT: {
                    if (cost.getValue() < 0.0) {
                        result.add(I18n.func_135052_a((String)"roots.tooltip.modifier.specific_decreased_cost", (Object[])new Object[]{cost.getHerb().getName(), Math.floor(cost.getValue() * 100.0) + "%"}));
                        break;
                    }
                    result.add(I18n.func_135052_a((String)"roots.tooltip.modifier.specific_increased_cost", (Object[])new Object[]{cost.getHerb().getName(), Math.floor(cost.getValue() * 100.0) + "%"}));
                    break;
                }
                case SPECIFIC_COST_MULTIPLIER: {
                    if (cost.getValue() < 0.0) {
                        result.add(I18n.func_135052_a((String)"roots.tooltip.modifier.specific_decreased_cost", (Object[])new Object[]{cost.getHerb().getName(), Math.floor(cost.getValue() * 100.0) + "%"}));
                        break;
                    }
                    result.add(I18n.func_135052_a((String)"roots.tooltip.modifier.specific_increased_cost", (Object[])new Object[]{cost.getHerb().getName(), Math.floor(cost.getValue() * 100.0) + "%"}));
                    break;
                }
            }
        }
        return result;
    }

    @Override
    public IModifierCore getCore() {
        if (this.modifier == null) {
            return BaseModifiers.AIR;
        }
        return this.modifier.getCore();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        try {
            tag.func_74778_a("m", this.modifier.getRegistryName().toString());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        tag.func_74757_a("a", this.applied);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.modifier = ModifierRegistry.get(new ResourceLocation(tag.func_74779_i("m")));
        this.applied = tag.func_74767_n("a");
    }

    @Override
    public abstract Object2DoubleOpenHashMap<Herb> apply(Object2DoubleOpenHashMap<Herb> var1, CostType var2);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseModifierInstance that = (BaseModifierInstance)o;
        return this.applied == that.applied && this.modifier.equals(that.modifier);
    }

    public int hashCode() {
        return Objects.hash(this.modifier, this.applied);
    }

    @Override
    @Nonnull
    public ResourceLocation getRegistryName() {
        return this.modifier.getRegistryName();
    }

    @Override
    public List<Property<SpellBase.ModifierCost>> asProperties() {
        return Collections.emptyList();
    }
}

