/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.item;

import epicsquid.mysticallib.item.ItemBase;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.roots.Roots;
import epicsquid.roots.api.Herb;
import epicsquid.roots.client.Keybinds;
import epicsquid.roots.config.GeneralConfig;
import epicsquid.roots.handler.PouchHandler;
import epicsquid.roots.init.HerbRegistry;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.integration.baubles.pouch.BaublesHook;
import epicsquid.roots.item.IItemPouch;
import epicsquid.roots.item.PouchType;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ItemPouch
extends ItemBase
implements IItemPouch {
    protected PouchType type = PouchType.COMPONENT;

    public ItemPouch(@Nonnull String name) {
        super(name);
        this.func_77625_d(1);
    }

    public ItemPouch(@Nonnull String name, PouchType type) {
        this(name);
        this.type = type;
    }

    public PouchType getType() {
        return this.type;
    }

    public static PouchType getPouchType(ItemStack pouch) {
        if (!(pouch.func_77973_b() instanceof ItemPouch)) {
            return null;
        }
        return ((ItemPouch)pouch.func_77973_b()).getType();
    }

    public static double getHerbQuantity(EntityPlayer player, ItemStack pouch, Herb herb) {
        if (player.field_70170_p.field_72995_K) {
            return 0.0;
        }
        PouchHandler pouchHandler = PouchHandler.getHandler(pouch);
        if (pouchHandler == null) {
            return 0.0;
        }
        double count = ItemPouch.getNbtQuantity(pouch, herb.getName());
        IItemHandlerModifiable handler = pouchHandler.getHerbs();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190926_b() || !herb.equals(HerbRegistry.getHerbByItem(stack.func_77973_b()))) continue;
            count += (double)stack.func_190916_E();
        }
        return count;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            player.openGui((Object)Roots.getInstance(), 16, world, 0, 0, 0);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    private static ItemStack createData(ItemStack stack, Herb herb, double quantity) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74780_a(herb.getName(), quantity);
        return stack;
    }

    private static double getNbtQuantity(@Nonnull ItemStack stack, String plantName) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(plantName)) {
            return stack.func_77978_p().func_74769_h(plantName);
        }
        return 0.0;
    }

    public static double useQuantity(EntityPlayer player, ItemStack stack, Herb herb, double quantity) {
        if (player.field_70170_p.field_72995_K) {
            return 0.0;
        }
        double temp = quantity;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(herb.getName())) {
            if ((temp -= stack.func_77978_p().func_74769_h(herb.getName())) >= 0.0) {
                stack.func_77978_p().func_82580_o(herb.getName());
                if (temp > 0.0 && ItemPouch.addHerbToNbt(player, stack, herb)) {
                    temp = ItemPouch.useQuantity(player, stack, herb, temp);
                }
            } else {
                stack.func_77978_p().func_74780_a(herb.getName(), stack.func_77978_p().func_74769_h(herb.getName()) - quantity);
                temp = 0.0;
            }
        } else if (ItemPouch.addHerbToNbt(player, stack, herb)) {
            temp = ItemPouch.useQuantity(player, stack, herb, quantity);
        }
        return temp;
    }

    private static boolean addHerbToNbt(EntityPlayer player, ItemStack pouch, Herb herb) {
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        PouchHandler pouchHandler = PouchHandler.getHandler(pouch);
        if (pouchHandler == null) {
            return false;
        }
        IItemHandlerModifiable handler = pouchHandler.getHerbs();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190926_b() || !HerbRegistry.isHerb(stack.func_77973_b()) || !Objects.equals(HerbRegistry.getHerbByItem(stack.func_77973_b()), herb) || handler.extractItem(i, 1, false).func_190926_b()) continue;
            ItemPouch.createData(pouch, herb, 1.0);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        EnumDyeColor color;
        if (GeneralConfig.AutoEquipPouches && Loader.isModLoaded((String)"baubles")) {
            tooltip.add(TextFormatting.GREEN + I18n.func_135052_a((String)"roots.tooltip.pouch", (Object[])new Object[]{Keybinds.POUCH_KEYBIND.getDisplayName()}));
        } else {
            tooltip.add(TextFormatting.GREEN + I18n.func_135052_a((String)"roots.tooltip.pouch2", (Object[])new Object[]{Keybinds.POUCH_KEYBIND.getDisplayName()}));
        }
        if (GeneralConfig.AutoRefillPouches) {
            tooltip.add("");
            tooltip.add(TextFormatting.LIGHT_PURPLE + I18n.func_135052_a((String)"roots.tooltip.refill", (Object[])new Object[0]));
        }
        NBTTagCompound tag = ItemUtil.getOrCreateTag((ItemStack)stack);
        EnumDyeColor enumDyeColor = color = this == ModItems.fey_pouch ? EnumDyeColor.BLUE : EnumDyeColor.BROWN;
        if (tag.func_150297_b("color", 3)) {
            color = EnumDyeColor.func_176764_b((int)tag.func_74762_e("color"));
        }
        tooltip.add("");
        tooltip.add(I18n.func_135052_a((String)"roots.tooltip.color", (Object[])new Object[]{I18n.func_135052_a((String)color.func_176762_d(), (Object[])new Object[0])}));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (Loader.isModLoaded((String)"baubles")) {
            return BaublesHook.getInstance();
        }
        return null;
    }
}

