/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.integration.jei.loot;

import epicsquid.roots.recipe.SpiritDrops;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class LootWrapper
implements IRecipeWrapper,
ITooltipCallback<ItemStack> {
    public final LootRecipe recipe;

    public LootWrapper(LootRecipe recipe) {
        this.recipe = recipe;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.ITEM, (Object)this.recipe.bagType);
        ingredients.setOutputs(VanillaTypes.ITEM, this.recipe.stacks);
    }

    public ItemStack getType() {
        return this.recipe.bagType;
    }

    public List<ItemStack> getStacks() {
        return this.recipe.stacks;
    }

    public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<String> tooltip) {
        if (slotIndex == 0) {
            return;
        }
        SpiritDrops.SpiritItem spirit = (SpiritDrops.SpiritItem)((Object)this.recipe.drops.get(slotIndex - 1));
        float weight = (float)spirit.field_76292_a / (float)this.recipe.totalWeight * 100.0f;
        tooltip.add("" + ingredient.func_190916_E() + " (" + String.format("%.2f", Float.valueOf(weight)) + "%)");
    }

    public static class LootRecipe {
        private final ItemStack bagType;
        private final List<SpiritDrops.SpiritItem> drops;
        private final List<ItemStack> stacks;
        private int totalWeight = 0;

        public LootRecipe(Item bagType, List<SpiritDrops.SpiritItem> drops) {
            this.bagType = new ItemStack(bagType);
            this.drops = drops;
            this.stacks = drops.stream().peek(o -> this.totalWeight += o.field_76292_a).map(SpiritDrops.SpiritItem::getItem).collect(Collectors.toList());
        }
    }
}

