/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.event;

import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.roots.block.BlockElementalSoil;
import epicsquid.roots.config.ElementalSoilConfig;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.mechanics.Harvest;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="roots")
public class SoilHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onCropHarvest(BlockEvent.HarvestDropsEvent event) {
        int fertility;
        IBlockState plantable = event.getState();
        if (event.getHarvester() == null || !(plantable.func_177230_c() instanceof IPlantable)) {
            return;
        }
        BlockPos eventPos = event.getPos();
        World eventWorld = event.getWorld();
        IBlockState soil = eventWorld.func_180495_p(eventPos.func_177972_a(EnumFacing.DOWN));
        Block soilBlock = soil.func_177230_c();
        if (soilBlock == ModBlocks.elemental_soil_fire && SoilHandler.soilCanSustainPlant(event, soilBlock, soil)) {
            int cookingMultiplier = (Integer)soil.func_177229_b((IProperty)BlockElementalSoil.FIRE_MULTIPLIER);
            if (cookingMultiplier > 0) {
                ItemStack seed = Harvest.getSeed(event.getState());
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                Random random = eventWorld.field_73012_v;
                boolean foundSeed = false;
                for (ItemStack stack : event.getDrops()) {
                    ItemStack result;
                    if (!foundSeed) {
                        if (!seed.func_190926_b()) {
                            if (ItemUtil.equalWithoutSize((ItemStack)seed, (ItemStack)stack)) {
                                foundSeed = true;
                                drops.add(stack);
                                continue;
                            }
                        } else if (stack.func_77973_b() instanceof IPlantable) {
                            foundSeed = true;
                            seed = stack;
                            drops.add(stack);
                            continue;
                        }
                    }
                    if (!(result = FurnaceRecipes.func_77602_a().func_151395_a(stack)).func_190926_b()) {
                        ItemStack copy = result.func_77946_l();
                        copy.func_190920_e(cookingMultiplier - 1 > 0 ? random.nextInt(cookingMultiplier - 1) + 1 : 1);
                        drops.add(copy);
                        continue;
                    }
                    drops.add(stack);
                }
                if (Harvest.isGrown(plantable) && random.nextInt(3) == 0 && !eventWorld.field_72995_K) {
                    eventWorld.func_72838_d((Entity)new EntityXPOrb(eventWorld, (double)eventPos.func_177958_n() + 0.5, (double)eventPos.func_177956_o() + 0.5, (double)eventPos.func_177952_p() + 0.5, 1));
                }
                event.getDrops().clear();
                event.getDrops().addAll(drops);
            }
        } else if (soilBlock == ModBlocks.elemental_soil_earth && SoilHandler.soilCanSustainPlant(event, soilBlock, soil) && Harvest.isGrown(event.getState()) && (fertility = ((Integer)soil.func_177229_b((IProperty)BlockElementalSoil.EARTH_FERTILITY)).intValue()) > 0) {
            ArrayList<ItemStack> newDrops = new ArrayList<ItemStack>();
            Random random = eventWorld.field_73012_v;
            for (ItemStack stack : event.getDrops()) {
                newDrops.add(stack);
                if (ElementalSoilConfig.EarthSkipSeeds && stack.func_77973_b() instanceof IPlantable || random.nextInt(3) >= fertility) continue;
                ItemStack copy = stack.func_77946_l();
                copy.func_190920_e(fertility > 2 ? 2 : 1);
                newDrops.add(stack.func_77946_l());
            }
            event.getDrops().clear();
            event.getDrops().addAll(newDrops);
        }
    }

    private static boolean soilCanSustainPlant(BlockEvent.HarvestDropsEvent event, Block soilBlock, IBlockState soilBlockState) {
        return soilBlock.canSustainPlant(soilBlockState, (IBlockAccess)event.getWorld(), event.getPos().func_177972_a(EnumFacing.DOWN), EnumFacing.UP, (IPlantable)event.getState().func_177230_c());
    }

    @SubscribeEvent
    public static void onCropsGrowPost(BlockEvent.CropGrowEvent.Post cropGrowEvent) {
        ((BlockElementalSoil)ModBlocks.elemental_soil_water).doHarvest(cropGrowEvent);
    }

    @SubscribeEvent
    public static void onCropsGrowPre(BlockEvent.CropGrowEvent.Pre cropGrowEvent) {
        int speed;
        IBlockState plant;
        BlockPos downPos = cropGrowEvent.getPos().func_177972_a(EnumFacing.DOWN);
        IBlockState soil = cropGrowEvent.getWorld().func_180495_p(downPos);
        if (soil.func_177230_c() == ModBlocks.elemental_soil_air && (plant = cropGrowEvent.getWorld().func_180495_p(cropGrowEvent.getPos())).func_177230_c() instanceof IPlantable && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)cropGrowEvent.getWorld(), downPos, EnumFacing.UP, (IPlantable)plant.func_177230_c()) && (speed = ((Integer)soil.func_177229_b((IProperty)BlockElementalSoil.AIR_SPEED)).intValue()) > 0) {
            cropGrowEvent.setResult(cropGrowEvent.getWorld().field_73012_v.nextInt(3) == 0 ? Event.Result.ALLOW : Event.Result.DEFAULT);
        }
    }
}

