/*
 * Decompiled with CFR 0.152.
 */
package requious.tile;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import requious.block.BlockFluidEmitter;
import requious.data.FluidEmitterData;
import requious.entity.EntitySpark;
import requious.entity.ISparkValue;
import requious.entity.spark.TargetTile;
import requious.entity.spark.ValueFluid;
import requious.tile.ISparkAcceptor;
import requious.tile.TileEntityEmitter;

public class TileEntityFluidEmitter
extends TileEntityEmitter {
    FluidStack fluid;
    EntitySpark currentSpark;
    FluidTank capability = new FluidTank(0){

        public void setCapacity(int capacity) {
        }

        public int getCapacity() {
            return TileEntityFluidEmitter.this.getCapacity();
        }

        @Nullable
        public FluidStack drainInternal(int maxDrain, boolean doDrain) {
            this.capacity = TileEntityFluidEmitter.this.getCapacity();
            return super.drainInternal(maxDrain, doDrain);
        }

        public int fillInternal(FluidStack resource, boolean doFill) {
            this.capacity = TileEntityFluidEmitter.this.getCapacity();
            return super.fillInternal(resource, doFill);
        }
    };

    public FluidEmitterData getData() {
        BlockFluidEmitter emitter = (BlockFluidEmitter)this.func_145838_q();
        return (FluidEmitterData)emitter.getData();
    }

    public int getCapacity() {
        return this.getData().capacity;
    }

    public int getAmount() {
        if (this.fluid == null) {
            return 0;
        }
        return this.fluid.amount;
    }

    @Override
    public void setTarget(World world, BlockPos pos, EnumFacing facing) {
        if (world != this.field_145850_b) {
            return;
        }
        if (pos.equals((Object)this.field_174879_c)) {
            return;
        }
        this.target = pos;
        this.func_70296_d();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.getFacing().func_176734_d() == facing;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.getFacing().func_176734_d() == facing) {
            return (T)capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    void ioEnergy(EnumFacing dir, TileEntity attachedTile) {
        if (attachedTile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir)) {
            FluidStack extracted;
            IFluidHandler storage = (IFluidHandler)attachedTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir);
            if (this.isEmitter()) {
                extracted = storage.drain(this.getCapacity() - this.getAmount(), true);
                if (extracted != null) {
                    this.capability.fillInternal(extracted, true);
                }
                this.func_70296_d();
            }
            if (this.isReceiver()) {
                extracted = this.capability.drain(this.getAmount(), false);
                if (extracted != null) {
                    int inserted = storage.fill(extracted, true);
                    this.capability.drain(inserted, true);
                }
                this.func_70296_d();
            }
        }
    }

    @Override
    void sendPacket() {
        if (this.getAmount() >= this.getCapacity() && this.isPacketDead()) {
            TileEntity targetTile = this.getTargetTile();
            ValueFluid value = new ValueFluid(this.fluid);
            if (targetTile instanceof ISparkAcceptor && ((ISparkAcceptor)targetTile).canAccept(value)) {
                this.currentSpark = new EntitySpark(this.field_145850_b);
                Vec3d velocity = this.getBurstVelocity(this.getFacing()).func_72441_c((this.random.nextDouble() - 0.5) * 0.3, (this.random.nextDouble() - 0.5) * 0.3, (this.random.nextDouble() - 0.5) * 0.3);
                this.currentSpark.init((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c, new TargetTile(targetTile), value);
                this.currentSpark.pushHistory((Comparable)this.field_174879_c);
                this.field_145850_b.func_72838_d((Entity)this.currentSpark);
                this.fluid = null;
                this.func_70296_d();
            }
        }
    }

    private boolean isPacketDead() {
        return this.currentSpark == null || this.currentSpark.field_70128_L;
    }

    @Override
    void receivePacket(EntitySpark spark) {
        ISparkValue value = spark.value;
        if (value instanceof ValueFluid) {
            this.capability.fill(((ValueFluid)value).getFluid(), false);
        }
    }

    @Override
    public boolean canAccept(ISparkValue value) {
        if (value instanceof ValueFluid) {
            return ((ValueFluid)value).getAmount() <= this.getCapacity() - this.getAmount();
        }
        return false;
    }

    @Override
    int getInterval() {
        return this.getData().interval;
    }
}

