/*
 * Decompiled with CFR 0.152.
 */
package requious.tile;

import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Optional;
import requious.block.BlockAssembly;
import requious.data.AssemblyData;
import requious.data.AssemblyProcessor;
import requious.data.component.ComponentEnergy;
import requious.tile.ILaserAcceptor;
import requious.util.Facing;
import requious.util.ILaserStorage;
import requious.util.MachineVisual;
import requious.util.Misc;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergyTile", modid="ic2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="ic2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="ic2")})
public class TileEntityAssembly
extends TileEntity
implements ITickable,
ILaserAcceptor,
IEnergyTile,
IEnergySink,
IEnergySource {
    Random random = new Random();
    AssemblyProcessor processor;
    ResourceLocation block;
    boolean shouldSync;
    EntityPlayer owner;
    boolean active;

    public void setBlock(BlockAssembly block) {
        this.block = block.getRegistryName();
    }

    public BlockAssembly getBlock() {
        return (BlockAssembly)Block.field_149771_c.func_82594_a((Object)this.block);
    }

    public AssemblyProcessor getProcessor() {
        return this.processor;
    }

    public AssemblyData getData() {
        BlockAssembly assembly = this.getBlock();
        return assembly.getData();
    }

    public boolean isActive() {
        return this.active;
    }

    public static EnumFacing toLocalSide(EnumFacing facing, EnumFacing side) {
        if (side == null) {
            return null;
        }
        switch (facing) {
            case DOWN: {
                return side.func_176734_d();
            }
            case UP: {
                return side;
            }
            case SOUTH: {
                return side.func_176732_a(EnumFacing.Axis.X);
            }
            case NORTH: {
                return side.func_176734_d().func_176732_a(EnumFacing.Axis.X);
            }
            case WEST: {
                return side.func_176732_a(EnumFacing.Axis.Z);
            }
            case EAST: {
                return side.func_176734_d().func_176732_a(EnumFacing.Axis.Z);
            }
        }
        return null;
    }

    public static EnumFacing toGlobalSide(EnumFacing facing, EnumFacing side) {
        if (side == null) {
            return null;
        }
        switch (facing) {
            case DOWN: {
                return side.func_176734_d();
            }
            case UP: {
                return side;
            }
            case SOUTH: {
                return side.func_176734_d().func_176732_a(EnumFacing.Axis.X);
            }
            case NORTH: {
                return side.func_176732_a(EnumFacing.Axis.X);
            }
            case WEST: {
                return side.func_176734_d().func_176732_a(EnumFacing.Axis.Z);
            }
            case EAST: {
                return side.func_176732_a(EnumFacing.Axis.Z);
            }
        }
        return null;
    }

    public static EnumFacing toSide(EnumFacing facing, Facing side) {
        if (side.isGlobal()) {
            return side.getFacing();
        }
        return TileEntityAssembly.toGlobalSide(facing, side.getFacing());
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        boolean hasCapability = false;
        if (this.processor != null) {
            hasCapability = this.processor.hasCapability(capability, TileEntityAssembly.toLocalSide(this.getFacing(), facing), facing);
        }
        if (!hasCapability) {
            hasCapability = super.hasCapability(capability, facing);
        }
        return hasCapability;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        Object instance = null;
        if (this.processor != null) {
            instance = this.processor.getCapability(capability, TileEntityAssembly.toLocalSide(this.getFacing(), facing), facing);
        }
        if (instance == null) {
            instance = super.getCapability(capability, facing);
        }
        return (T)instance;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void breakBlock(World world, BlockPos pos) {
        this.processor.machineBroken(world, new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74778_a("assembly", this.block.toString());
        if (this.processor != null) {
            this.processor.writeToNBT(tag);
        }
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.block = new ResourceLocation(tag.func_74779_i("assembly"));
        if (this.processor == null) {
            this.initProcessor();
        }
        this.processor.readFromNBT(tag);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.shouldSync = true;
    }

    public void func_73660_a() {
        if (this.processor == null) {
            this.initProcessor();
        } else {
            boolean newActive;
            for (MachineVisual visual : this.processor.getVisuals()) {
                visual.update(this);
            }
            this.processor.update();
            if (this.processor.isDirty()) {
                this.func_70296_d();
            }
            if ((newActive = this.processor.isActive()) != this.active) {
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
                this.active = newActive;
            }
        }
        if (this.shouldSync) {
            Misc.syncTE(this, false);
        }
    }

    private void initProcessor() {
        this.processor = this.getData().constructProcessor();
        this.processor.setTile(this);
        if (this.owner != null) {
            this.processor.setOwner(this.owner);
        }
    }

    public EnumFacing getFacing() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        return (EnumFacing)state.func_177229_b((IProperty)BlockAssembly.facing);
    }

    public void setOwner(EntityPlayer player) {
        if (player == null) {
            return;
        }
        if (this.processor != null) {
            this.processor.setOwner(player);
        } else {
            this.owner = player;
        }
    }

    @Override
    public ILaserStorage getLaserStorage(EnumFacing laserDirection) {
        if (this.processor == null) {
            return null;
        }
        return this.processor.getLaserAcceptor(TileEntityAssembly.toLocalSide(this.getFacing(), laserDirection.func_176734_d()), laserDirection.func_176734_d());
    }

    @Override
    public boolean isValid() {
        return !this.func_145837_r();
    }

    @Override
    public BlockPos getPosition() {
        return this.func_174877_v();
    }

    public boolean emitsEnergyTo(IEnergyAcceptor acceptor, EnumFacing side) {
        ComponentEnergy.CollectorIC2 handler = this.processor.getIC2Handler();
        return handler.canOutputEnergy(TileEntityAssembly.toLocalSide(this.getFacing(), side), side);
    }

    public double getDemandedEnergy() {
        ComponentEnergy.CollectorIC2 handler = this.processor.getIC2Handler();
        return handler.getInputEnergy();
    }

    public int getSinkTier() {
        ComponentEnergy.CollectorIC2 handler = this.processor.getIC2Handler();
        return handler.getInputTier();
    }

    public double injectEnergy(EnumFacing side, double amount, double voltage) {
        ComponentEnergy.CollectorIC2 handler = this.processor.getIC2Handler();
        return handler.inject(TileEntityAssembly.toLocalSide(this.getFacing(), side), side, amount, voltage);
    }

    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        ComponentEnergy.CollectorIC2 handler = this.processor.getIC2Handler();
        return handler.canInputEnergy(TileEntityAssembly.toLocalSide(this.getFacing(), side), side);
    }

    public double getOfferedEnergy() {
        ComponentEnergy.CollectorIC2 handler = this.processor.getIC2Handler();
        return handler.getOutputEnergy();
    }

    public void drawEnergy(double amount) {
        ComponentEnergy.CollectorIC2 handler = this.processor.getIC2Handler();
        handler.draw(amount);
    }

    public int getSourceTier() {
        ComponentEnergy.CollectorIC2 handler = this.processor.getIC2Handler();
        return handler.getOutputTier();
    }

    public String toString() {
        String dataName = "NO DATA";
        if (this.getData() != null) {
            dataName = this.getData().resourceName;
        }
        return String.format("%s (%s)", super.toString(), dataName);
    }
}

