/*
 * Decompiled with CFR 0.152.
 */
package requious.proxy;

import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import requious.Registry;
import requious.entity.EntitySpark;
import requious.entity.RenderNull;
import requious.item.ItemTuningFork;
import requious.particle.IParticleAnchor;
import requious.particle.ParticleGlow;
import requious.particle.ParticleRenderer;
import requious.particle.ParticleSmokeColored;
import requious.proxy.IProxy;

public class ClientProxy
implements IProxy {
    ParticleRenderer renderer;
    Random random = new Random();

    @Override
    public void preInit() {
        this.renderer = new ParticleRenderer();
        RenderingRegistry.registerEntityRenderingHandler(EntitySpark.class, (IRenderFactory)new RenderNull.Factory());
    }

    @Override
    public void init() {
        Registry.initColors();
    }

    @Override
    public void emitGlow(World world, IParticleAnchor anchor, double x, double y, double z, double vx, double vy, double vz, Color color, float scaleMin, float scaleMax, int lifetime, float partialTime) {
        this.renderer.addParticle(new ParticleGlow(world, anchor, x, y, z, vx, vy, vz, color, scaleMin, scaleMax, lifetime, partialTime));
    }

    @Override
    public void spawnLightning(World world, IParticleAnchor anchor, double x1, double y1, double z1, double x2, double y2, double z2, int segments, double wildness, Color color, double thickness, int lifetime) {
        double prevx = x1;
        double prevy = y1;
        double prevz = z1;
        for (int i = 1; i <= segments; ++i) {
            double coeff = (double)i / (double)segments;
            double wildCoeff = Math.sin(Math.PI * coeff) * wildness;
            double currx = MathHelper.func_151238_b((double)x1, (double)x2, (double)coeff) + (this.random.nextDouble() - 0.5) * 2.0 * wildCoeff;
            double curry = MathHelper.func_151238_b((double)y1, (double)y2, (double)coeff) + (this.random.nextDouble() - 0.5) * 2.0 * wildCoeff;
            double currz = MathHelper.func_151238_b((double)z1, (double)z2, (double)coeff) + (this.random.nextDouble() - 0.5) * 2.0 * wildCoeff;
            this.spawnSpark(world, anchor, prevx, prevy, prevz, currx, curry, currz, color, thickness, lifetime);
            prevx = currx;
            prevy = curry;
            prevz = currz;
        }
    }

    @Override
    public void spawnSpark(World world, IParticleAnchor anchor, double x1, double y1, double z1, double x2, double y2, double z2, Color color, double thickness, int lifetime) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double segments = Math.ceil(dist) * 10.0;
        int i = 0;
        while ((double)i <= segments) {
            double coeff = (double)i / segments;
            double sparkx = MathHelper.func_151238_b((double)x1, (double)x2, (double)coeff);
            double sparky = MathHelper.func_151238_b((double)y1, (double)y2, (double)coeff);
            double sparkz = MathHelper.func_151238_b((double)z1, (double)z2, (double)coeff);
            this.emitGlow(world, anchor, sparkx, sparky, sparkz, 0.0, 0.0, 0.0, color, (float)thickness, (float)thickness, lifetime, 0.0f);
            ++i;
        }
    }

    @Override
    public void emitSmoke(World world, double x, double y, double z, double vx, double vy, double vz, Color color, int lifetime, boolean fullBright) {
        ParticleSmokeColored particle = new ParticleSmokeColored(world, x, y, z, vx, vy, vz, lifetime, color, fullBright);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
    }

    @Override
    public boolean shouldRenderArcs() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack mainStack = player.func_184614_ca();
        ItemStack offStack = player.func_184592_cb();
        return mainStack.func_77973_b() instanceof ItemTuningFork || offStack.func_77973_b() instanceof ItemTuningFork;
    }
}

