/*
 * Decompiled with CFR 0.152.
 */
package requious.item;

import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import requious.data.BatteryData;
import requious.item.IDynamicItemModel;

public class ItemBattery
extends Item
implements IDynamicItemModel {
    BatteryData data;

    public ItemBattery(BatteryData data) {
        this.data = data;
        this.func_185043_a(new ResourceLocation("requious", "energy"), (stack, worldIn, entityIn) -> {
            IEnergyStorage battery = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            if (battery != null) {
                return (float)battery.getEnergyStored() / (float)battery.getMaxEnergyStored();
            }
            return 0.0f;
        });
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.data.stackSize;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int energy = this.getEnergy(stack);
        int capacity = this.getCapacity();
        if (this.data.showToolip) {
            tooltip.add(I18n.func_135052_a((String)("requious.unit." + this.getUnit()), (Object[])new Object[]{energy, capacity}));
        }
    }

    private String getUnit() {
        return "fe";
    }

    public boolean func_77614_k() {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)this.getEmpty());
            items.add((Object)this.getFull());
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.data.hasBar();
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        double lerp = 1.0 - this.getDurabilityForDisplay(stack);
        return this.data.barColor.get(lerp).getRGB();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        int energy = this.getEnergy(stack);
        return 1.0 - (double)energy / (double)this.getCapacity();
    }

    public ItemStack getEmpty() {
        return new ItemStack((Item)this);
    }

    public ItemStack getFull() {
        return this.getFull(1.0);
    }

    public ItemStack getFull(double ratio) {
        ItemStack stack = this.getEmpty();
        this.setEnergy(stack, (int)((double)this.getCapacity() * ratio));
        return stack;
    }

    private int getCapacity() {
        return this.data.capacity;
    }

    private int getEnergy(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null) {
            return compound.func_74762_e("energy");
        }
        return 0;
    }

    private void setEnergy(ItemStack stack, int energy) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        compound.func_74768_a("energy", energy);
        stack.func_77982_d(compound);
    }

    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, NBTTagCompound nbt) {
        return new BatteryCapability(stack);
    }

    @Override
    public Color getTint(ItemStack stack, int tintIndex) {
        return this.data.getColor(stack, tintIndex);
    }

    private class BatteryCapability
    implements ICapabilityProvider,
    IEnergyStorage {
        ItemStack stack;

        public BatteryCapability(ItemStack stack) {
            this.stack = stack;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityEnergy.ENERGY;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityEnergy.ENERGY) {
                return (T)this;
            }
            return null;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int energy = this.getEnergyStored();
            int received = Math.min(maxReceive, ItemBattery.this.getCapacity() - energy);
            if (received < this.getMinInput()) {
                return 0;
            }
            received = Math.min(received, this.getMaxInput());
            if (!simulate) {
                ItemBattery.this.setEnergy(this.stack, energy + received);
            }
            return received;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int energy = this.getEnergyStored();
            int extracted = Math.min(maxExtract, energy);
            if (extracted < this.getMinOutput()) {
                return 0;
            }
            extracted = Math.min(extracted, this.getMaxOutput());
            if (!simulate) {
                ItemBattery.this.setEnergy(this.stack, energy - extracted);
            }
            return extracted;
        }

        public int getEnergyStored() {
            return ItemBattery.this.getEnergy(this.stack);
        }

        public int getMaxEnergyStored() {
            return ItemBattery.this.getCapacity();
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }

        private int getMinInput() {
            return ItemBattery.this.data.minInput;
        }

        private int getMaxInput() {
            return ItemBattery.this.data.maxInput;
        }

        private int getMinOutput() {
            return ItemBattery.this.data.minOutput;
        }

        private int getMaxOutput() {
            return ItemBattery.this.data.maxOutput;
        }
    }
}

