/*
 * Decompiled with CFR 0.152.
 */
package requious.gui;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.input.Mouse;
import requious.data.AssemblyProcessor;
import requious.gui.ContainerAssembly;
import requious.gui.slot.BaseSlot;
import requious.util.Misc;

public class GuiAssembly
extends GuiContainer {
    private static final ResourceLocation boxGuiLocation = new ResourceLocation("requious", "textures/gui/assembly.png");
    private AssemblyProcessor assembly;
    private EntityPlayer player;

    public GuiAssembly(EntityPlayer player, AssemblyProcessor assembly) {
        super((Container)new ContainerAssembly(player, assembly));
        this.field_147000_g = 184;
        this.assembly = assembly;
        this.player = player;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    private boolean isMouseOverSlot(Slot slotIn, int mouseX, int mouseY) {
        int width = 16;
        int height = 16;
        if (slotIn instanceof BaseSlot) {
            Vec3i size = ((BaseSlot)slotIn).getSize();
            width = size.func_177958_n();
            height = size.func_177956_o();
        }
        return this.func_146978_c(slotIn.field_75223_e, slotIn.field_75221_f, width, height, mouseX, mouseY);
    }

    public Slot func_146975_c(int x, int y) {
        for (int i = 0; i < this.field_147002_h.field_75151_b.size(); ++i) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(i);
            if (!this.isMouseOverSlot(slot, x, y)) continue;
            boolean enabled = slot.func_111238_b();
            if (slot instanceof BaseSlot) {
                enabled = ((BaseSlot)slot).isHoverEnabled();
            }
            if (!enabled) continue;
            return slot;
        }
        return null;
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        Slot slot = this.func_146975_c(mouseX, mouseY);
        if (slot instanceof BaseSlot && ((BaseSlot)slot).hasToolTip()) {
            List<String> tooltip = ((BaseSlot)slot).getTooltip();
            FontRenderer font = this.field_146289_q;
            this.drawHoveringText(tooltip, mouseX, mouseY, font);
        } else {
            super.func_191948_b(mouseX, mouseY);
        }
    }

    protected void func_146285_a(ItemStack stack, int x, int y) {
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        GuiUtils.preItemToolTip((ItemStack)stack);
        List tooltip = this.func_191927_a(stack);
        if (tooltip.size() >= 1) {
            tooltip.set(0, (String)tooltip.get(0) + TextFormatting.GRAY + " x" + stack.func_190916_E());
        }
        this.drawHoveringText(tooltip, x, y, font == null ? this.field_146289_q : font);
        GuiUtils.postItemToolTip();
    }

    public void func_146977_a(Slot slotIn) {
        TextureAtlasSprite textureatlassprite;
        int i = slotIn.field_75223_e;
        int j = slotIn.field_75221_f;
        ItemStack itemstack = slotIn.func_75211_c();
        boolean flag = false;
        boolean flag1 = slotIn == this.field_147005_v && !this.field_147012_x.func_190926_b() && !this.field_147004_w;
        ItemStack itemstack1 = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        String s = null;
        if (slotIn == this.field_147005_v && !this.field_147012_x.func_190926_b() && this.field_147004_w && !itemstack.func_190926_b()) {
            itemstack = itemstack.func_77946_l();
            itemstack.func_190920_e(itemstack.func_190916_E() / 2);
        } else if (this.field_147007_t && this.field_147008_s.contains(slotIn) && !itemstack1.func_190926_b()) {
            if (this.field_147008_s.size() == 1) {
                return;
            }
            if (Container.func_94527_a((Slot)slotIn, (ItemStack)itemstack1, (boolean)true) && this.field_147002_h.func_94531_b(slotIn)) {
                itemstack = itemstack1.func_77946_l();
                flag = true;
                Container.func_94525_a((Set)this.field_147008_s, (int)this.field_146987_F, (ItemStack)itemstack, (int)(slotIn.func_75211_c().func_190926_b() ? 0 : slotIn.func_75211_c().func_190916_E()));
                int k = Math.min(itemstack.func_77976_d(), slotIn.func_178170_b(itemstack));
                if (itemstack.func_190916_E() > k) {
                    s = TextFormatting.YELLOW.toString() + k;
                    itemstack.func_190920_e(k);
                }
            } else {
                this.field_147008_s.remove(slotIn);
                this.func_146980_g();
            }
        }
        this.field_73735_i = 100.0f;
        this.field_146296_j.field_77023_b = 100.0f;
        if (itemstack.func_190926_b() && slotIn.func_111238_b() && (textureatlassprite = slotIn.getBackgroundSprite()) != null) {
            GlStateManager.func_179140_f();
            this.field_146297_k.func_110434_K().func_110577_a(slotIn.getBackgroundLocation());
            this.func_175175_a(i, j, textureatlassprite, 16, 16);
            GlStateManager.func_179145_e();
            flag1 = true;
        }
        if (!flag1) {
            if (flag) {
                GuiAssembly.func_73734_a((int)i, (int)j, (int)(i + 16), (int)(j + 16), (int)-2130706433);
            }
            if (s == null) {
                s = Misc.getCountString(itemstack);
            }
            GlStateManager.func_179126_j();
            this.field_146296_j.func_184391_a((EntityLivingBase)this.field_146297_k.field_71439_g, itemstack, i, j);
            this.field_146296_j.func_180453_a(this.field_146289_q, itemstack, i, j, s);
        }
        this.field_146296_j.field_77023_b = 0.0f;
        this.field_73735_i = 0.0f;
    }

    protected void func_146979_b(int mousex, int mousey) {
        for (Slot slot : this.field_147002_h.field_75151_b) {
            if (!(slot instanceof BaseSlot) || !((BaseSlot)slot).shouldRender()) continue;
            ((BaseSlot)slot).renderForeground(this, slot.field_75223_e, slot.field_75221_f, mousex, mousey);
        }
    }

    protected void func_146976_a(float partialTicks, int mousex, int mousey) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(boxGuiLocation);
        int xPos = (this.field_146294_l - this.field_146999_f) / 2;
        int yPos = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(xPos, yPos, 0, 0, this.field_146999_f, this.field_147000_g);
        for (Slot slot : this.field_147002_h.field_75151_b) {
            this.field_146297_k.func_110434_K().func_110577_a(boxGuiLocation);
            if (!(slot instanceof BaseSlot) || !((BaseSlot)slot).shouldRender()) continue;
            ((BaseSlot)slot).renderBackground(this, xPos + slot.field_75223_e, yPos + slot.field_75221_f, partialTicks, mousex, mousey);
        }
    }

    protected void func_184098_a(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        super.func_184098_a(slotIn, slotId, mouseButton, type);
        if (slotIn instanceof BaseSlot) {
            ((BaseSlot)slotIn).clientClick(this.player, this.field_147012_x, mouseButton, type);
        }
    }

    public void func_146274_d() throws IOException {
        Slot slot;
        super.func_146274_d();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int wheel = Mouse.getEventDWheel();
        if (wheel != 0 && (slot = this.func_146975_c(mouseX, mouseY)) instanceof BaseSlot) {
            ((BaseSlot)slot).clientScroll((int)Math.signum(wheel));
        }
    }
}

