/*
 * Decompiled with CFR 0.152.
 */
package requious.data.component;

import crafttweaker.annotations.ZenRegister;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import requious.compat.crafttweaker.SlotVisualCT;
import requious.data.AssemblyProcessor;
import requious.data.component.ComponentBase;
import requious.gui.slot.SelectSlot;
import requious.util.ComponentFace;
import requious.util.SlotVisual;
import stanhebben.zenscript.annotations.ReturnsSelf;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.requious.SelectionSlot")
public class ComponentSelection
extends ComponentBase {
    int index;
    String selectionGroup;
    Integer maxSelection;
    public SlotVisual background = SlotVisual.SELECTION_SLOT;
    public SlotVisual foreground = SlotVisual.EMPTY;

    public ComponentSelection(String selectionGroup, int index) {
        super(ComponentFace.None);
        this.selectionGroup = selectionGroup;
        this.index = index;
    }

    @ZenMethod
    public ComponentSelection setMaxSelection(int max) {
        this.maxSelection = max;
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentSelection setBackground(SlotVisualCT visual) {
        this.background = SlotVisualCT.unpack(visual);
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentSelection setForeground(SlotVisualCT visual) {
        this.foreground = SlotVisualCT.unpack(visual);
        return this;
    }

    @Override
    public ComponentBase.Slot createSlot() {
        return new Slot(this);
    }

    public static class SelectionList {
        Slot master;
        List<ItemStack> selectedItems = new ArrayList<ItemStack>();
        List<ItemStack> items = new ArrayList<ItemStack>();
        int maxSelection = Integer.MAX_VALUE;
        int scroll;

        public SelectionList(Slot master) {
            this.master = master;
            this.setProperties(master);
        }

        public void setProperties(Slot slot) {
            if (((ComponentSelection)slot.component).maxSelection != null) {
                this.maxSelection = ((ComponentSelection)slot.component).maxSelection;
            }
        }

        public void reset() {
            this.items.clear();
        }

        public boolean isSelected(int index) {
            return index < this.selectedItems.size();
        }

        public ItemStack get(int index) {
            int maxIndex = 0;
            for (ItemStack stack : this.items) {
                if (this.listContains(this.selectedItems, stack)) continue;
                ++maxIndex;
            }
            if (index >= (maxIndex += this.selectedItems.size())) {
                return ItemStack.field_190927_a;
            }
            if (index < this.selectedItems.size()) {
                return this.getSelected(index);
            }
            return this.getUnselected(index - this.selectedItems.size());
        }

        public ItemStack getSelected(int index) {
            return this.selectedItems.get(index);
        }

        private boolean isSelected(ItemStack stack) {
            for (ItemStack selection : this.selectedItems) {
                if (!ItemStack.func_77989_b((ItemStack)selection, (ItemStack)stack) || selection.func_190916_E() != stack.func_190916_E()) continue;
                return true;
            }
            return false;
        }

        public ItemStack getUnselected(int index) {
            index = this.positiveModulo(index + this.scroll, Math.max(this.items.size() - this.selectedItems.size(), 1));
            for (ItemStack selection : this.items) {
                if (this.isSelected(selection)) continue;
                if (index <= 0) {
                    return selection;
                }
                --index;
            }
            return ItemStack.field_190927_a;
        }

        private int positiveModulo(int n, int mod) {
            int i = n % mod;
            return i < 0 ? i + mod : i;
        }

        public void scroll(int i) {
            this.scroll += i;
            this.master.markDirty();
        }

        public void add(ItemStack item) {
            if (!this.listContains(this.items, item)) {
                this.items.add(item);
            }
        }

        public void select(ItemStack item) {
            if (!item.func_190926_b() && !this.listContains(this.selectedItems, item)) {
                if (this.selectedItems.size() >= this.maxSelection) {
                    this.selectedItems.remove(0);
                }
                this.selectedItems.add(item);
                this.master.markDirty();
            }
        }

        private boolean listContains(List<ItemStack> items, ItemStack check) {
            for (ItemStack stack : items) {
                if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)check) || stack.func_190916_E() != check.func_190916_E()) continue;
                return true;
            }
            return false;
        }

        public void unselect(ItemStack item) {
            this.selectedItems.remove(item);
            this.master.markDirty();
        }

        public NBTTagCompound serializeNBT(NBTTagCompound compound) {
            NBTTagList list = new NBTTagList();
            for (ItemStack stack : this.selectedItems) {
                list.func_74742_a((NBTBase)stack.serializeNBT());
            }
            compound.func_74782_a("selected", (NBTBase)list);
            compound.func_74768_a("scroll", this.scroll);
            return compound;
        }

        public void deserializeNBT(NBTTagCompound compound) {
            this.selectedItems.clear();
            NBTTagList list = compound.func_150295_c("selected", 10);
            for (NBTBase element : list) {
                this.selectedItems.add(new ItemStack((NBTTagCompound)element));
            }
            this.scroll = compound.func_74762_e("scroll");
        }
    }

    public static class Collector
    extends ComponentBase.Collector {
        String selectionGroup;
        SelectionList selectionList;
        List<Slot> slots = new ArrayList<Slot>();

        public Collector(Slot master, String selectionGroup) {
            this.selectionList = new SelectionList(master);
            this.selectionGroup = selectionGroup;
        }

        private void addSlot(Slot slot) {
            this.slots.add(slot);
            slot.setSelectionList(this.selectionList);
            this.selectionList.setProperties(slot);
        }

        @Override
        public boolean accept(ComponentBase.Slot slot) {
            if (slot instanceof Slot && this.selectionGroup.equals(((Slot)slot).getSelectionGroup())) {
                this.addSlot((Slot)slot);
                return true;
            }
            return false;
        }

        @Override
        public boolean hasCapability() {
            return false;
        }

        @Override
        public void update() {
            this.selectionList.reset();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Collector) {
                return this.selectionGroup.equals(((Collector)obj).selectionGroup);
            }
            return false;
        }
    }

    public static class Slot
    extends ComponentBase.Slot<ComponentSelection> {
        SelectionList selectionList;

        public Slot(ComponentSelection component) {
            super(component);
        }

        @Override
        public void addCollectors(List<ComponentBase.Collector> collectors) {
            Collector item = new Collector(this, this.getSelectionGroup());
            if (!collectors.contains(item)) {
                collectors.add(item);
            }
        }

        @Override
        public net.minecraft.inventory.Slot createGui(AssemblyProcessor assembly, int x, int y) {
            return new SelectSlot(assembly, this, x, y);
        }

        @Override
        public void update() {
        }

        @Override
        public void machineBroken(World world, Vec3d position) {
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            if (this.isMaster()) {
                this.selectionList.serializeNBT(compound);
            }
            return compound;
        }

        public void deserializeNBT(NBTTagCompound compound) {
            if (this.isMaster()) {
                this.selectionList.deserializeNBT(compound);
            }
        }

        @Override
        public boolean isDirty() {
            return super.isDirty();
        }

        @Override
        public void markClean() {
            super.markClean();
        }

        public String getSelectionGroup() {
            return ((ComponentSelection)this.component).selectionGroup;
        }

        public void setSelectionList(SelectionList selectionList) {
            this.selectionList = selectionList;
        }

        public boolean isMaster() {
            return this.selectionList.master == this;
        }

        public SelectionList getSelectionList() {
            return this.selectionList;
        }

        public ItemStack getSelection() {
            return this.selectionList.get(((ComponentSelection)this.component).index);
        }

        public boolean isSelected() {
            return this.selectionList.isSelected(((ComponentSelection)this.component).index);
        }

        public void select() {
            this.selectionList.select(this.getSelection());
        }

        public void unselect() {
            this.selectionList.unselect(this.getSelection());
        }

        public void scroll(int i) {
            this.selectionList.scroll(i);
        }

        public void addSelection(ItemStack icon) {
            this.selectionList.add(icon);
        }

        public SlotVisual getBackground() {
            return ((ComponentSelection)this.component).background;
        }

        public SlotVisual getForeground() {
            return ((ComponentSelection)this.component).foreground;
        }
    }
}

