/*
 * Decompiled with CFR 0.152.
 */
package requious.data;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import requious.compat.crafttweaker.ColorCT;
import requious.util.color.ICustomColor;
import requious.util.color.NormalColor;
import stanhebben.zenscript.annotations.ZenMethod;

public class ItemData {
    @SerializedName(value="resourceName")
    public String resourceName;
    @SerializedName(value="model")
    public ResourceLocation model;
    @SerializedName(value="colors")
    public Color[] colorsSerialized = new Color[]{Color.WHITE};
    @SerializedName(value="stackSize")
    public int stackSize = 64;
    @Expose(serialize=false, deserialize=false)
    private transient Map<Integer, ICustomColor> colors = new HashMap<Integer, ICustomColor>();
    @Expose(serialize=false, deserialize=false)
    private transient ICustomColor baseColor = new NormalColor(Color.WHITE);

    public void init() {
        for (int i = 0; i < this.colorsSerialized.length; ++i) {
            this.colors.put(i, new NormalColor(this.colorsSerialized[i]));
        }
    }

    protected void setBaseColor(ICustomColor color) {
        this.baseColor = color;
    }

    @ZenMethod
    public void setColor(int index, ColorCT color) {
        this.colors.put(index, color.get());
    }

    public Color getColor(ItemStack stack, int index) {
        ICustomColor color = this.colors.get(index);
        if (color == null) {
            return this.baseColor.get(stack);
        }
        return color.get(stack);
    }
}

