/*
 * Decompiled with CFR 0.152.
 */
package requious.data;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import requious.compat.crafttweaker.ColorCT;
import requious.util.color.ICustomColor;
import requious.util.color.NormalColor;
import stanhebben.zenscript.annotations.ZenMethod;

public abstract class BaseData {
    @SerializedName(value="resourceName")
    public String resourceName;
    @SerializedName(value="model")
    public ResourceLocation model;
    @SerializedName(value="colors")
    public Color[] colorsSerialized = new Color[]{Color.WHITE};
    @SerializedName(value="hardness")
    public float hardness = 5.0f;
    @SerializedName(value="blastResistance")
    public float blastResistance = 5.0f;
    @SerializedName(value="aabb")
    public AxisAlignedBB aabb = Block.field_185505_j;
    @Expose(serialize=false, deserialize=false)
    private transient Map<Integer, ICustomColor> colors = new HashMap<Integer, ICustomColor>();
    @Expose(serialize=false, deserialize=false)
    private transient ICustomColor baseColor = new NormalColor(Color.WHITE);

    public void init() {
        for (int i = 0; i < this.colorsSerialized.length; ++i) {
            this.colors.put(i, new NormalColor(this.colorsSerialized[i]));
        }
    }

    protected void setBaseColor(ICustomColor color) {
        this.baseColor = color;
    }

    @ZenMethod
    public void setColor(int index, ColorCT color) {
        this.colors.put(index, color.get());
    }

    public Color getColor(int index) {
        ICustomColor color = this.colors.get(index);
        if (color == null) {
            return this.baseColor.get();
        }
        return color.get();
    }
}

