/*
 * Decompiled with CFR 0.152.
 */
package requious.compat.crafttweaker;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.command.ICommandSender;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.server.IServer;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IFacing;
import crafttweaker.api.world.IVector3d;
import crafttweaker.api.world.IWorld;
import crafttweaker.mc1120.server.MCServer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import requious.compat.crafttweaker.ColorCT;
import requious.compat.crafttweaker.RandomCT;
import requious.data.AssemblyProcessor;
import requious.data.component.ComponentBase;
import requious.data.component.ComponentEnergy;
import requious.data.component.ComponentFluid;
import requious.data.component.ComponentItem;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.requious.MachineContainer")
public class MachineContainer
implements ICommandSender {
    public AssemblyProcessor assembly;
    public RandomCT random;

    public MachineContainer(AssemblyProcessor assembly) {
        this.assembly = assembly;
        this.random = new RandomCT();
    }

    public TileEntity getTile() {
        return this.assembly.getTile();
    }

    public EnumFacing getTileFacing() {
        return this.assembly.getFacing();
    }

    public String getDisplayName() {
        return this.assembly.getCommandSender().func_70005_c_();
    }

    public IBlockPos getPosition() {
        return CraftTweakerMC.getIBlockPos((BlockPos)this.assembly.getCommandSender().func_180425_c());
    }

    @ZenGetter(value="world")
    public IWorld getWorld() {
        return CraftTweakerMC.getIWorld((World)this.getTile().func_145831_w());
    }

    public IServer getServer() {
        return new MCServer(this.assembly.getCommandSender().func_184102_h());
    }

    public void sendMessage(String text) {
        this.assembly.getCommandSender().func_145747_a((ITextComponent)new TextComponentString(text));
    }

    public Object getInternal() {
        return this.assembly.getCommandSender();
    }

    @ZenGetter(value="pos")
    public IBlockPos getPos() {
        return CraftTweakerMC.getIBlockPos((BlockPos)this.getTile().func_174877_v());
    }

    @ZenGetter(value="block")
    public IBlock getBlock() {
        BlockPos pos = this.getTile().func_174877_v();
        return CraftTweakerMC.getBlock((IBlockAccess)this.getTile().func_145831_w(), (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
    }

    @ZenGetter(value="state")
    public crafttweaker.api.block.IBlockState getBlockState() {
        return CraftTweakerMC.getBlockState((IBlockState)this.getTile().func_145831_w().func_180495_p(this.getTile().func_174877_v()));
    }

    @ZenGetter(value="facing")
    public IFacing getFacing() {
        return CraftTweakerMC.getIFacing((EnumFacing)this.getTileFacing());
    }

    @ZenGetter(value="random")
    public RandomCT getRandom() {
        return this.random;
    }

    @ZenMethod
    public int getInteger(String name) {
        Object value = this.assembly.getVariable(name);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return 0;
    }

    @ZenMethod
    public double getDouble(String name) {
        Object value = this.assembly.getVariable(name);
        if (value instanceof Double) {
            return (Double)value;
        }
        return 0.0;
    }

    @ZenMethod
    public String getString(String name) {
        Object value = this.assembly.getVariable(name);
        if (value instanceof String) {
            return (String)value;
        }
        return "";
    }

    @ZenMethod
    public IItemStack getItem(String name) {
        Object value = this.assembly.getVariable(name);
        if (value instanceof ItemStack) {
            return CraftTweakerMC.getIItemStack((ItemStack)((ItemStack)value));
        }
        return CraftTweakerMC.getIItemStack((ItemStack)ItemStack.field_190927_a);
    }

    @ZenMethod
    public ILiquidStack getFluid(String name) {
        Object value = this.assembly.getVariable(name);
        if (value instanceof FluidStack) {
            return CraftTweakerMC.getILiquidStack((FluidStack)((FluidStack)value));
        }
        return CraftTweakerMC.getILiquidStack(null);
    }

    @ZenMethod
    public IVector3d getVector(String name) {
        Object value = this.assembly.getVariable(name);
        if (value instanceof Vec3d) {
            return CraftTweakerMC.getIVector3d((Vec3d)((Vec3d)value));
        }
        return CraftTweakerMC.getIVector3d((Vec3d)Vec3d.field_186680_a);
    }

    @ZenMethod
    public void setInteger(String name, int value) {
        this.assembly.setVariable(name, value);
    }

    @ZenMethod
    public void setDouble(String name, double value) {
        this.assembly.setVariable(name, value);
    }

    @ZenMethod
    public void setString(String name, String value) {
        this.assembly.setVariable(name, value);
    }

    @ZenMethod
    public void setFacing(String name, IFacing value) {
        this.assembly.setVariable(name, value.getInternal());
    }

    @ZenMethod
    public void setColor(String name, ColorCT value) {
        this.assembly.setVariable(name, value.get());
    }

    @ZenMethod
    public void setItem(String name, IItemStack value) {
        this.assembly.setVariable(name, CraftTweakerMC.getItemStack((IItemStack)value));
    }

    @ZenMethod
    public void setFluid(String name, ILiquidStack value) {
        this.assembly.setVariable(name, CraftTweakerMC.getLiquidStack((ILiquidStack)value));
    }

    @ZenMethod
    public void setVector(String name, double x, double y, double z) {
        this.assembly.setVariable(name, new Vec3d(x, y, z));
    }

    @ZenMethod
    public IItemStack getItem(int x, int y) {
        ComponentBase.Slot slot = this.assembly.getSlot(x, y);
        ItemStack stack = ItemStack.field_190927_a;
        if (slot instanceof ComponentItem.IItemSlot) {
            stack = ((ComponentItem.IItemSlot)((Object)slot)).getItem().getStack();
        }
        return CraftTweakerMC.getIItemStack((ItemStack)stack);
    }

    @ZenMethod
    public ILiquidStack getFluid(int x, int y) {
        ComponentBase.Slot slot = this.assembly.getSlot(x, y);
        FluidStack stack = null;
        if (slot instanceof ComponentFluid.Slot) {
            stack = ((ComponentFluid.Slot)slot).getContents();
        }
        return CraftTweakerMC.getILiquidStack(stack);
    }

    @ZenMethod
    public int getEnergy(int x, int y) {
        ComponentBase.Slot slot = this.assembly.getSlot(x, y);
        if (slot instanceof ComponentEnergy.Slot) {
            return ((ComponentEnergy.Slot)slot).getAmount();
        }
        return 0;
    }

    @ZenMethod
    public void setItem(int x, int y, IItemStack stack) {
        ComponentBase.Slot slot = this.assembly.getSlot(x, y);
        if (slot instanceof ComponentItem.IItemSlot) {
            ((ComponentItem.IItemSlot)((Object)slot)).getItem().setStack(CraftTweakerMC.getItemStack((IItemStack)stack));
        }
    }

    @ZenMethod
    public void setFluid(int x, int y, ILiquidStack stack) {
        ComponentBase.Slot slot = this.assembly.getSlot(x, y);
        if (slot instanceof ComponentFluid.Slot) {
            ((ComponentFluid.Slot)slot).setContents(CraftTweakerMC.getLiquidStack((ILiquidStack)stack));
        }
    }

    @ZenMethod
    public void setEnergy(int x, int y, int amount) {
        ComponentBase.Slot slot = this.assembly.getSlot(x, y);
        if (slot instanceof ComponentEnergy.Slot) {
            ((ComponentEnergy.Slot)slot).setAmount(amount);
        }
    }

    @ZenMethod
    public IItemStack insertItem(String group, IItemStack stack) {
        ItemStack remainder = this.assembly.insertItem(group, CraftTweakerMC.getItemStack((IItemStack)stack));
        return CraftTweakerMC.getIItemStack((ItemStack)remainder);
    }

    @ZenMethod
    public IItemStack extractItem(String group, IIngredient filter) {
        ItemStack extracted = this.assembly.extractItem(group, stack -> filter.matches(CraftTweakerMC.getIItemStack((ItemStack)stack)), filter.getAmount());
        return CraftTweakerMC.getIItemStack((ItemStack)extracted);
    }

    @ZenMethod
    public ILiquidStack insertFluid(String group, ILiquidStack stack) {
        FluidStack remainder = this.assembly.insertFluid(group, CraftTweakerMC.getLiquidStack((ILiquidStack)stack));
        return CraftTweakerMC.getILiquidStack((FluidStack)remainder);
    }

    @ZenMethod
    public ILiquidStack extractFluid(String group, IIngredient filter) {
        FluidStack extracted = this.assembly.extractFluid(group, stack -> filter.matches(CraftTweakerMC.getILiquidStack((FluidStack)stack)), filter.getAmount());
        return CraftTweakerMC.getILiquidStack((FluidStack)extracted);
    }

    @ZenMethod
    public int insertEnergy(String group, int energy) {
        int remainder = this.assembly.insertEnergy(group, energy);
        return remainder;
    }

    @ZenMethod
    public int extractEnergy(String group, int energy) {
        int extracted = this.assembly.extractEnergy(group, energy);
        return extracted;
    }
}

