/*
 * Decompiled with CFR 0.152.
 */
package requious.compat.crafttweaker;

import com.google.common.collect.Lists;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import requious.Registry;
import requious.compat.crafttweaker.ShapeBase;
import requious.compat.crafttweaker.ShapeCut;
import requious.compat.crafttweaker.ShapeStacked;
import requious.item.Shape;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.annotations.ZenCaster;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenMethodStatic;
import stanhebben.zenscript.annotations.ZenOperator;

@ZenClass(value="requious.shape")
@ZenRegister
public interface IShape {
    public Shape getShape();

    @ZenCaster
    @ZenMethod
    default public IItemStack toItem() {
        return CraftTweakerMC.getIItemStack((ItemStack)Registry.SHAPE.create(this.getShape()));
    }

    @ZenMethod
    default public IShape[] cut() {
        Shape shape = this.getShape();
        ArrayList<ShapeCut> shapes = new ArrayList<ShapeCut>();
        for (Shape piece = shape; piece != null; piece = piece.getInner()) {
            shapes.add(new ShapeCut(piece, Shape.Piece.TOP_LEFT));
            shapes.add(new ShapeCut(piece, Shape.Piece.TOP_RIGHT));
            shapes.add(new ShapeCut(piece, Shape.Piece.BOTTOM_LEFT));
            shapes.add(new ShapeCut(piece, Shape.Piece.BOTTOM_RIGHT));
        }
        return shapes.toArray(new IShape[shapes.size()]);
    }

    @ZenMethod
    default public IShape[] unstack() {
        Shape shape = this.getShape();
        ArrayList<ShapeBase> shapes = new ArrayList<ShapeBase>();
        for (Shape piece = shape; piece != null; piece = piece.getInner()) {
            shapes.add(new ShapeBase(piece));
        }
        return shapes.toArray(new IShape[shapes.size()]);
    }

    @ZenMethod
    default public IShape toLayer() {
        Shape shape = this.getShape();
        return new ShapeBase(shape.toLayer());
    }

    @ZenOperator(value=OperatorType.ADD)
    default public IShape stack(IShape other) {
        return new ShapeStacked(Lists.newArrayList((Object[])new Shape[]{this.getShape(), other.getShape()}));
    }

    @ZenMethodStatic
    public static IShape stack(IShape[] shapes) {
        return new ShapeStacked(Arrays.stream(shapes).map(IShape::getShape).collect(Collectors.toList()));
    }
}

