/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.script;

import ivorius.ivtoolkit.blocks.BlockPositions;
import ivorius.ivtoolkit.blocks.BlockStates;
import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import ivorius.reccomplex.gui.worldscripts.TableDataSourceWorldScriptHolder;
import ivorius.reccomplex.nbt.NBTNone;
import ivorius.reccomplex.world.gen.feature.StructureGenerator;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureLoadContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructurePrepareContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureSpawnContext;
import ivorius.reccomplex.world.gen.feature.structure.generic.GenericStructure;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.RunTransformer;
import ivorius.reccomplex.world.gen.script.WorldScript;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldScriptHolder
implements WorldScript<NBTNone> {
    @Nullable
    public NBTTagCompound worldData;
    public BlockPos origin = BlockPos.field_177992_a;
    public IBlockState replaceState = Blocks.field_150350_a.func_176223_P();

    public static void writeBlockState(NBTTagCompound compound, IBlockState state, String id, String meta) {
        compound.func_74778_a(id, ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c())).toString());
        compound.func_74774_a(meta, (byte)BlockStates.toMetadata(state));
    }

    public static IBlockState readBlockState(NBTTagCompound compound, MCRegistry registry, String id, String meta) {
        Block block = registry.blockFromID(new ResourceLocation(compound.func_74779_i(id)));
        return block != null ? BlockStates.fromMetadata(block, compound.func_74771_c(meta)) : Blocks.field_150350_a.func_176223_P();
    }

    @Override
    public NBTNone prepareInstanceData(StructurePrepareContext context, BlockPos pos) {
        return new NBTNone();
    }

    @Override
    public NBTNone loadInstanceData(StructureLoadContext context, NBTBase nbt) {
        return new NBTNone();
    }

    @Override
    public void generate(StructureSpawnContext context, RunTransformer transformer, NBTNone instanceData, BlockPos pos) {
        if (this.worldData == null) {
            return;
        }
        GenericStructure structure = new GenericStructure();
        structure.worldDataCompound = this.worldData.func_74737_b();
        int[] strucSize = structure.size();
        BlockPos strucCoord = context.transform.apply(this.origin, new int[]{1, 1, 1}).func_177973_b((Vec3i)context.transform.apply(BlockPos.field_177992_a, strucSize)).func_177971_a((Vec3i)pos);
        new StructureGenerator<GenericStructure.InstanceData>(structure).asChild(context).transformer(transformer).lowerCoord(strucCoord).generationPredicate(p -> !p.equals((Object)pos)).generate();
        context.setBlock(pos, this.replaceState, 2);
    }

    @Override
    public String getDisplayString() {
        return "Holder";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TableDataSource tableDataSource(BlockPos realWorldPos, TableNavigator navigator, TableDelegate tableDelegate) {
        return new TableDataSourceWorldScriptHolder(this, realWorldPos, navigator, tableDelegate);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.worldData = compound.func_74764_b("worldData") ? compound.func_74775_l("worldData") : null;
        this.origin = BlockPositions.readFromNBT("origin", compound);
        this.replaceState = WorldScriptHolder.readBlockState(compound, RecurrentComplex.specialRegistry, "selfID", "selfMeta");
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        if (this.worldData != null) {
            compound.func_74782_a("worldData", (NBTBase)this.worldData.func_74737_b());
        }
        BlockPositions.writeToNBT("origin", this.origin, compound);
        WorldScriptHolder.writeBlockState(compound, this.replaceState, "selfID", "selfMeta");
    }
}

