/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.blocks;

import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;

public class BlockSurfacePos {
    public static final BlockSurfacePos ORIGIN = new BlockSurfacePos(0, 0);
    public final int x;
    public final int z;

    public BlockSurfacePos(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public static BlockSurfacePos from(ChunkPos chunkCoords, int x, int z) {
        return new BlockSurfacePos(chunkCoords.field_77276_a << 4 + x, chunkCoords.field_77275_b << 4 + z);
    }

    public static BlockSurfacePos from(BlockPos pos) {
        return new BlockSurfacePos(pos.func_177958_n(), pos.func_177952_p());
    }

    public ChunkPos chunkCoord() {
        return new ChunkPos(this.x >> 4, this.z >> 4);
    }

    public BlockPos blockPos(int y) {
        return new BlockPos(this.x, y, this.z);
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public static long toLong(int x, int z) {
        return (long)x & 0xFFFFFFFFL | ((long)z & 0xFFFFFFFFL) << 32;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockSurfacePos that = (BlockSurfacePos)o;
        if (this.x != that.x) {
            return false;
        }
        return this.z == that.z;
    }

    public int hashCode() {
        int result = this.x;
        result = 31 * result + this.z;
        return result;
    }

    public String toString() {
        return "[" + this.x + ", " + this.z + "]";
    }

    public BlockSurfacePos add(int x, int z) {
        return new BlockSurfacePos(this.x + x, this.z + z);
    }

    public BlockSurfacePos subtract(int x, int z) {
        return new BlockSurfacePos(this.x - x, this.z - z);
    }
}

