/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.decoration.client.render;

import javax.annotation.Nonnull;
import net.minecraft.client.model.ModelLeashKnot;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import vazkii.quark.decoration.entity.EntityLeashKnot2TheKnotting;
import vazkii.quark.world.client.render.ChainRenderer;

public class RenderLeashKnot2
extends Render<EntityLeashKnot2TheKnotting> {
    private static final ResourceLocation LEASH_KNOT_TEXTURES = new ResourceLocation("textures/entity/lead_knot.png");
    private final ModelLeashKnot leashKnotModel = new ModelLeashKnot();
    public static final IRenderFactory<EntityLeashKnot2TheKnotting> FACTORY = RenderLeashKnot2::new;

    public RenderLeashKnot2(RenderManager renderManagerIn) {
        super(renderManagerIn);
    }

    public boolean shouldRender(EntityLeashKnot2TheKnotting livingEntity, @Nonnull ICamera camera, double camX, double camY, double camZ) {
        if (super.func_177071_a((Entity)livingEntity, camera, camX, camY, camZ)) {
            return true;
        }
        if (livingEntity.func_110167_bD()) {
            Entity entity = livingEntity.func_110166_bE();
            return camera.func_78546_a(entity.func_184177_bl());
        }
        return false;
    }

    public void doRender(@Nonnull EntityLeashKnot2TheKnotting entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        float f = 0.125f;
        GlStateManager.func_179137_b((double)x, (double)(y + (double)f), (double)z);
        GlStateManager.func_179091_B();
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179141_d();
        this.func_180548_c((Entity)entity);
        if (this.field_188301_f) {
            GlStateManager.func_179142_g();
            GlStateManager.func_187431_e((int)this.func_188298_c((Entity)entity));
        }
        this.leashKnotModel.func_78088_a((Entity)entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        if (this.field_188301_f) {
            GlStateManager.func_187417_n();
            GlStateManager.func_179119_h();
        }
        GlStateManager.func_179121_F();
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
        if (!this.field_188301_f && entity.func_110167_bD()) {
            this.renderLeash(entity, x, y, z, partialTicks);
        }
    }

    protected ResourceLocation getEntityTexture(@Nonnull EntityLeashKnot2TheKnotting entity) {
        return LEASH_KNOT_TEXTURES;
    }

    protected void renderLeash(EntityLeashKnot2TheKnotting leash, double x, double y, double z, float partialTicks) {
        Entity entity = leash.func_110166_bE();
        if (entity == null) {
            return;
        }
        y -= (2.9 - (double)leash.field_70131_O) * 0.5;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        double d0 = this.interpolateValue(entity.field_70126_B, entity.field_70177_z, partialTicks * 0.5f) * 0.01745329238474369;
        double d1 = this.interpolateValue(entity.field_70127_C, entity.field_70125_A, partialTicks * 0.5f) * 0.01745329238474369;
        double d2 = Math.cos(d0);
        double d3 = Math.sin(d0);
        double d4 = Math.sin(d1);
        float off = 1.3f;
        if (entity instanceof EntityHanging) {
            off = 1.1f;
            d2 = 0.0;
            d3 = 0.0;
            d4 = -1.0;
        }
        double d5 = Math.cos(d1);
        double d6 = this.interpolateValue(entity.field_70169_q, entity.field_70165_t, partialTicks) - d2 * 0.7 - d3 * 0.5 * d5;
        double d7 = this.interpolateValue(entity.field_70167_r + (double)entity.func_70047_e() * 0.7 + (double)off, entity.field_70163_u + (double)entity.func_70047_e() * 0.7 + (double)off, partialTicks) - d4 * 0.5 - 0.25;
        double d8 = this.interpolateValue(entity.field_70166_s, entity.field_70161_v, partialTicks) - d3 * 0.7 + d2 * 0.5 * d5;
        double d9 = this.interpolateValue(leash.field_70760_ar, leash.field_70761_aq, partialTicks) * 0.01745329238474369 + 1.5707963267948966;
        d2 = Math.cos(d9) * (double)leash.field_70130_N * 0.4;
        d3 = Math.sin(d9) * (double)leash.field_70130_N * 0.4;
        double d10 = this.interpolateValue(leash.field_70169_q, leash.field_70165_t, partialTicks) + d2;
        double d11 = this.interpolateValue(leash.field_70167_r, leash.field_70163_u, partialTicks);
        double d12 = this.interpolateValue(leash.field_70166_s, leash.field_70161_v, partialTicks) + d3;
        x += d2;
        z += d3;
        double d13 = (float)(d6 - d10);
        double d14 = (float)(d7 - d11);
        double d15 = (float)(d8 - d12);
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        ChainRenderer.drawChainSegment(x, y, z, bufferbuilder, d13, d14, d15, 0.025, 0.0, 0.5f, 0.4f, 0.3f, 1.0);
        ChainRenderer.drawChainSegment(x, y, z, bufferbuilder, d13, d14, d15, 0.0, 0.025, 0.5f, 0.4f, 0.3f, 1.0);
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179089_o();
    }

    private double interpolateValue(double start, double end, double pct) {
        return start + (end - start) * pct;
    }
}

