/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openmods.colors.RGB;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    private static float fogRed;
    private static float fogGreen;
    private static float fogBlue;

    public static void setupBillboard(Entity rve) {
        GL11.glRotatef((float)(-rve.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)rve.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
    }

    public static World getRenderWorld() {
        if (Minecraft.func_71410_x() != null) {
            return Minecraft.func_71410_x().field_71441_e;
        }
        return null;
    }

    public static double interpolateValue(double current, double prev, float partialTickTime) {
        return prev + (double)partialTickTime * (current - prev);
    }

    public static float interpolateYaw(Entity e, float f) {
        return e.field_70126_B + (e.field_70177_z - e.field_70126_B) * f;
    }

    public static float interpolatePitch(Entity e, float f) {
        return e.field_70127_C + (e.field_70125_A - e.field_70127_C) * f;
    }

    public static void translateToPlayer(Entity e, float partialTickTime) {
        GL11.glTranslated((double)(RenderUtils.interpolateValue(e.field_70165_t, e.field_70169_q, partialTickTime) - TileEntityRendererDispatcher.field_147554_b), (double)(RenderUtils.interpolateValue(e.field_70163_u, e.field_70167_r, partialTickTime) - TileEntityRendererDispatcher.field_147555_c), (double)(RenderUtils.interpolateValue(e.field_70161_v, e.field_70166_s, partialTickTime) - TileEntityRendererDispatcher.field_147552_d));
    }

    public static void translateToWorld(Entity e, float partialTickTime) {
        GL11.glTranslated((double)RenderUtils.interpolateValue(e.field_70165_t, e.field_70169_q, partialTickTime), (double)RenderUtils.interpolateValue(e.field_70163_u, e.field_70167_r, partialTickTime), (double)RenderUtils.interpolateValue(e.field_70161_v, e.field_70166_s, partialTickTime));
    }

    public static void renderCube(IQuadSink sink, AxisAlignedBB aabb) {
        sink.addVertex(EnumFacing.NORTH, 0, aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
        sink.addVertex(EnumFacing.NORTH, 1, aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c);
        sink.addVertex(EnumFacing.NORTH, 2, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c);
        sink.addVertex(EnumFacing.NORTH, 3, aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c);
        sink.addVertex(EnumFacing.SOUTH, 0, aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f);
        sink.addVertex(EnumFacing.SOUTH, 1, aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f);
        sink.addVertex(EnumFacing.SOUTH, 2, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
        sink.addVertex(EnumFacing.SOUTH, 3, aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f);
        sink.addVertex(EnumFacing.WEST, 0, aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
        sink.addVertex(EnumFacing.WEST, 1, aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f);
        sink.addVertex(EnumFacing.WEST, 2, aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f);
        sink.addVertex(EnumFacing.WEST, 3, aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c);
        sink.addVertex(EnumFacing.EAST, 0, aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c);
        sink.addVertex(EnumFacing.EAST, 1, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c);
        sink.addVertex(EnumFacing.EAST, 2, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
        sink.addVertex(EnumFacing.EAST, 3, aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f);
        sink.addVertex(EnumFacing.DOWN, 0, aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
        sink.addVertex(EnumFacing.DOWN, 1, aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c);
        sink.addVertex(EnumFacing.DOWN, 2, aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f);
        sink.addVertex(EnumFacing.DOWN, 3, aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f);
        sink.addVertex(EnumFacing.UP, 0, aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c);
        sink.addVertex(EnumFacing.UP, 1, aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f);
        sink.addVertex(EnumFacing.UP, 2, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
        sink.addVertex(EnumFacing.UP, 3, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c);
    }

    public static void renderCube(IVertexSink sink, double x1, double y1, double z1, double x2, double y2, double z2) {
        sink.addVertex(x1, y1, z1);
        sink.addVertex(x1, y2, z1);
        sink.addVertex(x2, y2, z1);
        sink.addVertex(x2, y1, z1);
        sink.addVertex(x1, y1, z2);
        sink.addVertex(x2, y1, z2);
        sink.addVertex(x2, y2, z2);
        sink.addVertex(x1, y2, z2);
        sink.addVertex(x1, y1, z1);
        sink.addVertex(x1, y1, z2);
        sink.addVertex(x1, y2, z2);
        sink.addVertex(x1, y2, z1);
        sink.addVertex(x2, y1, z1);
        sink.addVertex(x2, y2, z1);
        sink.addVertex(x2, y2, z2);
        sink.addVertex(x2, y1, z2);
        sink.addVertex(x1, y1, z1);
        sink.addVertex(x2, y1, z1);
        sink.addVertex(x2, y1, z2);
        sink.addVertex(x1, y1, z2);
        sink.addVertex(x1, y2, z1);
        sink.addVertex(x1, y2, z2);
        sink.addVertex(x2, y2, z2);
        sink.addVertex(x2, y2, z1);
    }

    public static void renderSolidCube(Tessellator tes, double x1, double y1, double z1, double x2, double y2, double z2) {
        BufferBuilder wr = tes.func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        RenderUtils.renderCube((x, y, z) -> wr.func_181662_b(x, y, z).func_181675_d(), x1, y1, z1, x2, y2, z2);
        tes.func_78381_a();
    }

    public static void setColor(int rgb) {
        float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgb >> 0 & 0xFF) / 255.0f;
        GlStateManager.func_179124_c((float)r, (float)g, (float)b);
    }

    public static void setColor(int rgb, float alpha) {
        float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgb >> 0 & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)alpha);
    }

    public static void disableLightmap() {
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public static void enableLightmap() {
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179098_w();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public static RGB getFogColor() {
        return new RGB(fogRed, fogGreen, fogBlue);
    }

    public static void registerFogUpdater() {
        MinecraftForge.EVENT_BUS.register((Object)new FogColorUpdater());
    }

    public static interface IVertexSink {
        public void addVertex(double var1, double var3, double var5);
    }

    public static interface IQuadSink {
        public void addVertex(EnumFacing var1, int var2, double var3, double var5, double var7);
    }

    public static class FogColorUpdater {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onFogColor(EntityViewRenderEvent.FogColors evt) {
            fogRed = evt.getRed();
            fogGreen = evt.getGreen();
            fogBlue = evt.getBlue();
        }
    }
}

