/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.config;

import com.github.vfyjxf.nee.config.NEEConfig;
import com.github.vfyjxf.nee.utils.BlackIngredient;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IngredientBlackList {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final IngredientBlackList INSTANCE = new IngredientBlackList();
    private final List<BlackIngredient> blackList = new ArrayList<BlackIngredient>();

    private IngredientBlackList() {
    }

    public void addPreference(ItemStack stack, String acceptedType) {
        BlackIngredient ingredient = new BlackIngredient(stack, acceptedType);
        if (!this.blackList.contains(ingredient)) {
            this.blackList.add(ingredient);
            this.saveList();
        }
    }

    public List<BlackIngredient> getBlackList() {
        return this.blackList;
    }

    public void loadList() {
        List strings;
        File file = NEEConfig.getBlacklistFile();
        if (file == null || !file.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(file);){
            strings = IOUtils.readLines((Reader)reader);
        }
        catch (IOException e) {
            LOGGER.error("Failed to load blacklist from file {}", (Object)file, (Object)e);
            return;
        }
        List list = strings.stream().map(jsonString -> {
            try {
                return JsonToNBT.func_180713_a((String)jsonString);
            }
            catch (NBTException e) {
                throw new RuntimeException(e);
            }
        }).map(tagCompound -> {
            ItemStack identifier = new ItemStack(tagCompound.func_74775_l("identifier"));
            String acceptedType = tagCompound.func_74764_b("acceptedType") ? tagCompound.func_74779_i("acceptedType") : null;
            return new BlackIngredient(identifier, acceptedType);
        }).collect(Collectors.toList());
        this.blackList.clear();
        this.blackList.addAll(list);
    }

    public void saveList() {
        File file = NEEConfig.getBlacklistFile();
        if (file != null) {
            List strings = this.blackList.stream().map(blackIngredient -> blackIngredient.toTag().toString()).collect(Collectors.toList());
            try (FileWriter writer = new FileWriter(file);){
                IOUtils.writeLines(strings, (String)"\n", (Writer)writer);
            }
            catch (IOException e) {
                LOGGER.error("Failed to save blacklist to file {}", (Object)file, (Object)e);
            }
        }
    }
}

