/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.client.gui;

import appeng.client.gui.widgets.MEGuiTextField;
import com.github.vfyjxf.nee.client.gui.widgets.AddPreferenceButton;
import com.github.vfyjxf.nee.client.gui.widgets.ItemWidget;
import com.github.vfyjxf.nee.client.gui.widgets.OpenPreferenceDataButton;
import com.github.vfyjxf.nee.config.NEEConfig;
import com.github.vfyjxf.nee.jei.PatternTransferHandler;
import com.github.vfyjxf.nee.network.NEENetworkHandler;
import com.github.vfyjxf.nee.network.packet.PacketSlotStackSwitch;
import com.github.vfyjxf.nee.utils.GuiUtils;
import com.github.vfyjxf.nee.utils.ItemUtils;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class IngredientSwitcherWidget
extends Gui {
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private int scrollOffset;
    private int maxScroll;
    private boolean renderingTooltip;
    private ItemWidget selectedWidget;
    private final Slot selectedSlot;
    private final Rectangle slotRect;
    private final GuiContainer screen;
    private final MEGuiTextField searchField;
    private final List<ItemStack> allStacks;
    private final List<ItemStack> viewStacks;
    private final List<ItemWidget> widgets;
    private final AddPreferenceButton addButton;
    private final OpenPreferenceDataButton opeButton;
    private final OnResultApply action;

    public IngredientSwitcherWidget(int x, int y, int width, int height, List<ItemStack> ingredients, GuiContainer screen, Slot slot, OnResultApply action) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.screen = screen;
        this.selectedSlot = slot;
        this.slotRect = new Rectangle(slot.field_75223_e + screen.field_147003_i - 2, slot.field_75221_f + screen.field_147009_r - 2, 20, 20);
        this.searchField = new MEGuiTextField(Minecraft.func_71410_x().field_71466_p, x + 6, y + 5, 54, 11);
        this.searchField.func_146185_a(false);
        this.searchField.func_146203_f(25);
        this.searchField.func_146193_g(0xFFFFFF);
        this.searchField.setSelectionColor(-6684775);
        this.searchField.func_146189_e(true);
        this.searchField.selectAll();
        this.allStacks = ingredients.stream().filter(stack -> stack != null && !stack.func_190926_b()).collect(Collectors.toList());
        this.viewStacks = new ArrayList<ItemStack>(this.allStacks);
        this.widgets = new ArrayList<ItemWidget>();
        this.initWidgets(this.viewStacks);
        this.scrollOffset = 0;
        this.addButton = new AddPreferenceButton(this, x + width - 32, y + 5);
        this.opeButton = new OpenPreferenceDataButton(x + width - 19, y + 5);
        this.action = action;
    }

    private void initWidgets(List<ItemStack> stacks) {
        this.widgets.clear();
        for (int row = 0; row < 4; ++row) {
            int index;
            for (int col = 0; col < 4 && (index = row * 4 + col) < stacks.size(); ++col) {
                ItemStack stack = stacks.get(index);
                ItemWidget widget = new ItemWidget(stack, this.x + 7 + col * 18, this.y + 20 + row * 18);
                this.widgets.add(widget);
            }
        }
        this.maxScroll = (this.viewStacks.size() + 3) / 4 - 4;
    }

    public void draw(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (mc == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74518_a();
        GlStateManager.func_179097_i();
        TextureManager textureManager = mc.func_110434_K();
        textureManager.func_110577_a(new ResourceLocation("neenergistics", "textures/gui/ingredient_switcher_widget.png"));
        IngredientSwitcherWidget.func_146110_a((int)this.x, (int)this.y, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (float)this.width, (float)this.height);
        this.searchField.func_146194_f();
        this.addButton.func_191745_a(mc, mouseX, mouseY, partialTicks);
        this.opeButton.func_191745_a(mc, mouseX, mouseY, partialTicks);
        this.drawScrollBar(textureManager);
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
        for (ItemWidget widget : this.widgets) {
            widget.drawWidget(mc, mouseX, mouseY);
        }
        this.drawTooltips(mc, mouseX, mouseY);
    }

    private void drawScrollBar(TextureManager textureManager) {
        if (this.maxScroll <= 0) {
            return;
        }
        int scrollBarLeft = this.x + this.width - 13;
        int scrollBarTop = this.y + 20;
        textureManager.func_110577_a(new ResourceLocation("neenergistics", "textures/gui/states.png"));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.scrollOffset == 0) {
            this.func_73729_b(scrollBarLeft, scrollBarTop, 4, 51, 7, 11);
        } else {
            int offsetY = this.scrollOffset * 59 / this.maxScroll;
            this.func_73729_b(scrollBarLeft, offsetY + scrollBarTop, 4, 51, 7, 11);
        }
    }

    public void drawTooltips(Minecraft mc, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179141_d();
        GlStateManager.func_179084_k();
        this.renderingTooltip = true;
        this.addButton.drawTooltip(mc, mouseX, mouseY);
        this.opeButton.drawTooltip(mc, mouseX, mouseY);
        for (ItemWidget slot : this.widgets) {
            if (!slot.isMouseOver(mouseX, mouseY)) continue;
            slot.drawTooltips(mc, (GuiScreen)this.screen, mouseX, mouseY);
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        this.renderingTooltip = false;
    }

    public boolean handleKeyPressed(char typedChar, int eventKey) {
        if (this.searchField.func_146206_l() && eventKey == 28) {
            this.searchField.func_146195_b(false);
            return true;
        }
        if (this.searchField.func_146206_l() && this.searchField.func_146201_a(typedChar, eventKey)) {
            this.updateViews();
            return true;
        }
        return false;
    }

    public boolean handleMouseClicked(int eventButton, int mouseX, int mouseY) {
        this.searchField.func_146192_a(mouseX, mouseY, eventButton);
        if (this.addButton.func_146116_c(this.screen.field_146297_k, mouseX, mouseY)) {
            return true;
        }
        if (this.opeButton.func_146116_c(this.screen.field_146297_k, mouseX, mouseY)) {
            return true;
        }
        boolean result = false;
        for (ItemWidget widget : this.widgets) {
            widget.setSelected(false);
            if (!widget.isMouseOver(mouseX, mouseY)) continue;
            if (eventButton == 0) {
                return this.apply(widget.getIngredient());
            }
            if (eventButton != 2) continue;
            widget.setSelected(true);
            this.selectedWidget = widget;
            result = true;
        }
        this.addButton.update();
        return result;
    }

    public boolean mouseScroll(int offset, int mouseX, int mouseY) {
        if (offset == 0 || !this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        this.scrollOffset += Math.max(Math.min(-offset, 1), -1);
        this.scrollOffset = Math.max(Math.min(this.scrollOffset, this.maxScroll), 0);
        int startIndex = this.scrollOffset * 4;
        List<ItemStack> stacks = this.allStacks.subList(startIndex, this.viewStacks.size());
        this.initWidgets(stacks);
        return true;
    }

    public boolean apply(ItemStack stack) {
        try {
            ArrayList<Integer> craftingSlots = new ArrayList<Integer>();
            Map<String, List<ItemStack>> switcherData = PatternTransferHandler.getSwitcherData();
            if (NEEConfig.isSyncIngredientSwitcher()) {
                for (Slot slot : this.getCraftingSlots(this.screen)) {
                    boolean areIngredientEqual;
                    List<ItemStack> ingredients = switcherData.get("#" + slot.getSlotIndex());
                    List<ItemStack> selectedIngredients = switcherData.get("#" + this.selectedSlot.getSlotIndex());
                    boolean areItemStackEqual = this.selectedSlot.func_75216_d() && slot.func_75216_d() && ItemUtils.matches(this.selectedSlot.func_75211_c(), slot.func_75211_c());
                    boolean bl = areIngredientEqual = ingredients != null && !ingredients.isEmpty() && ingredients.size() == selectedIngredients.size() && ItemUtils.matches(ItemUtils.getFirstStack(ingredients), ItemUtils.getFirstStack(selectedIngredients));
                    if (!areItemStackEqual || !areIngredientEqual) continue;
                    craftingSlots.add(slot.field_75222_d);
                }
            } else {
                craftingSlots.add(this.selectedSlot.field_75222_d);
            }
            NEENetworkHandler.getInstance().sendToServer((IMessage)new PacketSlotStackSwitch(stack, craftingSlots));
            this.action.onApply();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private List<Slot> getCraftingSlots(GuiContainer gui) {
        ArrayList<Slot> craftingSlots = new ArrayList<Slot>();
        for (Slot slot : gui.field_147002_h.field_75151_b) {
            if (!GuiUtils.isCraftingSlot(slot)) continue;
            craftingSlots.add(slot);
        }
        return craftingSlots;
    }

    public void updateViews() {
        String text = this.searchField.func_146179_b();
        this.scrollOffset = 0;
        this.selectedWidget = null;
        this.viewStacks.clear();
        boolean searchMod = text.startsWith("@");
        String searchString = searchMod ? text.substring(1) : text;
        List<ItemStack> searched = this.allStacks.stream().filter(stack -> {
            if (searchMod) {
                String modid = stack.func_77973_b().getCreatorModId(stack);
                return modid != null && modid.toLowerCase().contains(searchString.toLowerCase());
            }
            return stack.func_82833_r().toLowerCase().contains(text);
        }).collect(Collectors.toList());
        this.viewStacks.addAll(searched);
        this.initWidgets(searched);
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
    }

    public boolean isMouseOverSlot(int mouseX, int mouseY) {
        return this.slotRect.contains(mouseX, mouseY);
    }

    public boolean isRenderingTooltip() {
        return this.renderingTooltip;
    }

    public ItemWidget getSelectedWidget() {
        return this.selectedWidget;
    }

    public void cleanSelection() {
        this.selectedWidget.setSelected(false);
        this.selectedWidget = null;
    }

    public static interface OnResultApply {
        public void onApply();
    }
}

