/*
 * Decompiled with CFR 0.152.
 */
package moretweaker.infinitycraft;

import com.blamejared.mtlib.helpers.InputHelper;
import com.rowan662.infinitycraft.machines.CompressorRecipes;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.lang.reflect.Field;
import java.util.Map;
import moretweaker.CraftingPart;
import moretweaker.Inputs;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="moretweaker.infinitycraft.Compressor")
@ZenRegister
@ModOnly(value="infinitycraft")
public class Compressor {
    private static Field mapField = null;

    @ZenMethod
    public static void addRecipe(IIngredient input, IItemStack output, final @Optional(valueLong=0L) int experience) {
        final CraftingPart in = Inputs.getPart(input);
        final ItemStack out = InputHelper.toStack((IItemStack)output);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                for (ItemStack stack : in.toStackList()) {
                    CompressorRecipes.instance().addCompressingRecipe(stack, out, (float)experience);
                }
            }

            public String describe() {
                return "Adds some infinitycraft compressor recipes";
            }
        });
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        final Object out = Inputs.getObject(output);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                Compressor.getCompressorMap().values().removeIf(s -> Inputs.matchesForRemoval(out, s));
            }

            public String describe() {
                return "Removes some infinitycraft compressor recipes";
            }
        });
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                Compressor.getCompressorMap().clear();
            }

            public String describe() {
                return "Removes all recipes for the infinitycraft Compressor";
            }
        });
    }

    private static Map<ItemStack, ItemStack> getCompressorMap() {
        try {
            if (mapField == null) {
                mapField = CompressorRecipes.class.getDeclaredField("compressingList");
                mapField.setAccessible(true);
            }
            return (Map)mapField.get(CompressorRecipes.instance());
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

