/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.mputils.client.settings;

import com.gendeathrow.mputils.api.client.gui.IMPSaveHandler;
import com.gendeathrow.mputils.client.settings.QuickCommandManager;
import com.gendeathrow.mputils.core.MPUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import net.minecraft.crash.CrashReport;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ReportedException;

public class MPUtils_SaveHandler {
    public static final File settingsDir = new File("mputils");
    public static final File settingsFile = new File(settingsDir, "settings.dat");
    public static final File globalQuickDir = new File(System.getProperty("user.home"), "." + settingsDir);
    public static final File globalQuickFile = new File(globalQuickDir, "settings.dat");
    public static boolean firstSave = false;
    private static boolean globalFirstSave = true;
    public static final ArrayList<IMPSaveHandler> extraSaveData = new ArrayList();

    public static void RegisterExtraData(IMPSaveHandler handler) {
        if (!extraSaveData.contains(handler)) {
            MPUtils.logger.info("Registered MPUtils SaveHandler: " + handler.getClass().getSimpleName());
            extraSaveData.add(handler);
        }
    }

    public static void loadSettings() {
        NBTTagCompound globalTag;
        NBTTagCompound mainTag = MPUtils_SaveHandler.ReadNBTFile(MPUtils_SaveHandler.getSettingsFile());
        if (mainTag != null && !mainTag.func_82582_d()) {
            for (IMPSaveHandler obj : extraSaveData) {
                obj.ReadNBT(mainTag);
            }
            QuickCommandManager.load(QuickCommandManager.getList(0), mainTag);
        }
        if ((globalTag = MPUtils_SaveHandler.ReadNBTFile(MPUtils_SaveHandler.getGlobalFile())) != null && !globalTag.func_82582_d()) {
            QuickCommandManager.load(QuickCommandManager.getList(1), globalTag);
        }
    }

    public static void saveSettings() {
        MPUtils_SaveHandler.saveLocal();
        MPUtils_SaveHandler.saveGlobal();
    }

    private static void saveLocal() {
        NBTTagCompound mainTag = new NBTTagCompound();
        QuickCommandManager.save(QuickCommandManager.getList(0), mainTag);
        for (IMPSaveHandler obj : extraSaveData) {
            obj.SaveNBT(mainTag);
        }
        MPUtils_SaveHandler.SaveNBTFile(settingsFile, mainTag);
    }

    private static void saveGlobal() {
        NBTTagCompound globalTag = new NBTTagCompound();
        QuickCommandManager.save(QuickCommandManager.getList(1), globalTag);
        MPUtils_SaveHandler.SaveNBTFile(globalQuickFile, globalTag);
    }

    private static File getSettingsFile() {
        try {
            if (settingsFile.exists()) {
                firstSave = false;
                return settingsFile;
            }
            firstSave = true;
            settingsDir.mkdirs();
            settingsFile.createNewFile();
            MPUtils_SaveHandler.saveLocal();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return settingsFile;
    }

    private static File getGlobalFile() {
        try {
            if (globalQuickFile.exists()) {
                globalFirstSave = false;
                return globalQuickFile;
            }
            globalFirstSave = true;
            globalQuickDir.mkdirs();
            globalQuickFile.createNewFile();
            MPUtils_SaveHandler.saveGlobal();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return settingsFile;
    }

    public static void SaveNBTFile(File file, NBTTagCompound nbt) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
        catch (IOException e) {
            throw new ReportedException(new CrashReport("An error occured while saving", new Throwable()));
        }
    }

    public static NBTTagCompound ReadNBTFile(File file) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (!file.exists()) {
            MPUtils.logger.warn("File load canceled, file (" + file.getAbsolutePath() + ")does not exist. This is normal for first run.");
            return null;
        }
        MPUtils.logger.info("File load successful.");
        try {
            nbt = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
            if (nbt.func_82582_d()) {
                return null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return nbt;
    }
}

