/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import mcmultipart.api.item.ItemBlockMultipart;
import mcmultipart.api.multipart.IMultipart;
import mcmultipart.multipart.MultipartRegistry;
import mcmultipart.network.MultipartNetworkHandler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;

public class MCMPCommonProxy {
    public void preInit() {
    }

    public void init() {
    }

    public EntityPlayer getPlayer() {
        return null;
    }

    public NetworkManager getNetworkManager() {
        return null;
    }

    public void scheduleTick(Runnable runnable, Side side) {
        if (side == Side.SERVER) {
            FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(runnable);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            MultipartNetworkHandler.flushChanges();
        }
    }

    @SubscribeEvent
    public void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        EnumActionResult result;
        Pair<MultipartRegistry.WrappedBlock, IMultipart> info;
        EntityPlayer player = event.getEntityPlayer();
        if (event.getHitVec() == null || event.getWorld() == null || event.getPos() == null || event.getHand() == null || event.getFace() == null || player == null) {
            return;
        }
        ItemStack stack = player.func_184586_b(event.getHand());
        if (!stack.func_190926_b() && (info = MultipartRegistry.INSTANCE.wrapPlacement(stack)) != null && ((MultipartRegistry.WrappedBlock)info.getKey()).getBlockPlacementLogic() != null && (result = this.placePart(stack, player, event.getWorld(), event.getPos(), event.getFace(), (float)event.getHitVec().field_72450_a, (float)event.getHitVec().field_72448_b, (float)event.getHitVec().field_72449_c, event.getHand(), info)) != EnumActionResult.PASS) {
            event.setCancellationResult(result);
            event.setCanceled(true);
        }
    }

    private EnumActionResult placePart(@Nonnull ItemStack itemstack, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull EnumHand hand, @Nonnull Pair<MultipartRegistry.WrappedBlock, IMultipart> info) {
        int meta = itemstack.func_77952_i();
        int size = itemstack.func_190916_E();
        NBTTagCompound nbt = null;
        if (itemstack.func_77978_p() != null) {
            nbt = itemstack.func_77978_p().func_74737_b();
        }
        if (!(itemstack.func_77973_b() instanceof ItemBucket)) {
            world.captureBlockSnapshots = true;
        }
        EnumActionResult ret = ItemBlockMultipart.place(player, world, pos, hand, side, hitX - (float)pos.func_177958_n(), hitY - (float)pos.func_177956_o(), hitZ - (float)pos.func_177952_p(), itemstack.func_77973_b(), ((MultipartRegistry.WrappedBlock)info.getKey()).getPlacementInfo(), (IMultipart)info.getValue(), ((MultipartRegistry.WrappedBlock)info.getKey()).getBlockPlacementLogic(), ((MultipartRegistry.WrappedBlock)info.getKey()).getPartPlacementLogic());
        world.captureBlockSnapshots = false;
        if (ret == EnumActionResult.SUCCESS) {
            int newMeta = itemstack.func_77952_i();
            int newSize = itemstack.func_190916_E();
            NBTTagCompound newNBT = null;
            if (itemstack.func_77978_p() != null) {
                newNBT = itemstack.func_77978_p().func_74737_b();
            }
            BlockEvent.MultiPlaceEvent placeEvent = null;
            List blockSnapshots = (List)world.capturedBlockSnapshots.clone();
            world.capturedBlockSnapshots.clear();
            itemstack.func_77964_b(meta);
            itemstack.func_190920_e(size);
            if (nbt != null) {
                itemstack.func_77982_d(nbt);
            }
            if (blockSnapshots.size() > 1) {
                placeEvent = ForgeEventFactory.onPlayerMultiBlockPlace((EntityPlayer)player, (List)blockSnapshots, (EnumFacing)side, (EnumHand)hand);
            } else if (blockSnapshots.size() == 1) {
                placeEvent = ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)player, (BlockSnapshot)((BlockSnapshot)blockSnapshots.get(0)), (EnumFacing)side, (EnumHand)hand);
            }
            if (placeEvent != null && placeEvent.isCanceled()) {
                ret = EnumActionResult.FAIL;
                for (BlockSnapshot blocksnapshot : Lists.reverse((List)blockSnapshots)) {
                    world.restoringBlockSnapshots = true;
                    blocksnapshot.restore(true, false);
                    world.restoringBlockSnapshots = false;
                }
            } else {
                itemstack.func_77964_b(newMeta);
                itemstack.func_190920_e(newSize);
                if (nbt != null) {
                    itemstack.func_77982_d(newNBT);
                }
                for (BlockSnapshot snap : blockSnapshots) {
                    int updateFlag = snap.getFlag();
                    IBlockState oldBlock = snap.getReplacedBlock();
                    IBlockState newBlock = world.func_180495_p(snap.getPos());
                    if (!newBlock.func_177230_c().hasTileEntity(newBlock)) {
                        newBlock.func_177230_c().func_176213_c(world, snap.getPos(), newBlock);
                    }
                    world.markAndNotifyBlock(snap.getPos(), null, oldBlock, newBlock, updateFlag);
                }
                player.func_71029_a(StatList.func_188057_b((Item)itemstack.func_77973_b()));
            }
        }
        world.capturedBlockSnapshots.clear();
        return ret;
    }
}

