/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core.predicate;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integratedtunnels.part.aspect.ITunnelTransfer;

public abstract class IngredientPredicate<T, M>
implements Predicate<T>,
ITunnelTransfer {
    private final IngredientComponent<T, M> ingredientComponent;
    private final T instance;
    private final M matchFlags;
    private final boolean blacklist;
    private final boolean empty;
    private final int maxQuantity;
    private final boolean exactQuantity;

    public IngredientPredicate(IngredientComponent<T, M> ingredientComponent, T instance, M matchFlags, boolean blacklist, boolean empty, int maxQuantity, boolean exactQuantity) {
        this.ingredientComponent = ingredientComponent;
        this.instance = instance;
        this.matchFlags = matchFlags;
        this.blacklist = blacklist;
        this.empty = empty;
        this.maxQuantity = maxQuantity;
        this.exactQuantity = exactQuantity;
    }

    public IngredientPredicate(IngredientComponent<T, M> ingredientComponent, boolean blacklist, boolean empty, int maxQuantity, boolean exactQuantity) {
        this(ingredientComponent, ingredientComponent.getMatcher().getEmptyInstance(), null, blacklist, empty, maxQuantity, exactQuantity);
    }

    public IngredientComponent<T, M> getIngredientComponent() {
        return this.ingredientComponent;
    }

    @Nonnull
    public T getInstance() {
        return this.instance;
    }

    public M getMatchFlags() {
        return this.matchFlags;
    }

    public boolean hasMatchFlags() {
        return this.matchFlags != null && !this.blacklist;
    }

    public boolean isBlacklist() {
        return this.blacklist;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public int getMaxQuantity() {
        return this.maxQuantity;
    }

    public boolean isExactQuantity() {
        return this.exactQuantity;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IngredientPredicate)) {
            return false;
        }
        IngredientPredicate that = (IngredientPredicate)obj;
        return this.ingredientComponent == that.ingredientComponent && this.ingredientComponent.getMatcher().matchesExactly(this.instance, that.instance) && Objects.equals(this.matchFlags, that.matchFlags) && this.blacklist == that.blacklist && this.empty == that.empty && this.maxQuantity == that.maxQuantity && this.exactQuantity == that.exactQuantity;
    }

    public int hashCode() {
        return this.ingredientComponent.hashCode() ^ this.ingredientComponent.getMatcher().hash(this.instance) ^ Objects.hashCode(this.matchFlags) ^ (this.blacklist ? 1 : 0) ^ (this.empty ? 2 : 4) ^ this.maxQuantity ^ (this.exactQuantity ? 8 : 16);
    }

    public static enum EmptyBehaviour {
        ANY,
        NONE;


        public static EmptyBehaviour fromBoolean(boolean emptyIsAny) {
            return emptyIsAny ? ANY : NONE;
        }
    }
}

