/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyEntityBase;

public abstract class ValueTypeListProxyEntityCapability<C, T extends IValueType<V>, V extends IValue>
extends ValueTypeListProxyEntityBase<T, V> {
    private final Capability<C> capability;
    private EnumFacing side;

    public ValueTypeListProxyEntityCapability(String name, T valueType, World world, Entity entity, Capability<C> capability, @Nullable EnumFacing side) {
        super(name, valueType, world, entity);
        this.capability = capability;
        this.side = side;
    }

    protected Optional<C> getCapability() {
        Entity e = this.getEntity();
        if (e != null && e.hasCapability(this.capability, this.side)) {
            return Optional.of(e.getCapability(this.capability, this.side));
        }
        return Optional.empty();
    }

    @Override
    public void writeGeneratedFieldsToNBT(NBTTagCompound tag) {
        super.writeGeneratedFieldsToNBT(tag);
        if (this.side != null) {
            tag.func_74768_a("side", this.side.ordinal());
        }
    }

    @Override
    public void readGeneratedFieldsFromNBT(NBTTagCompound tag) {
        super.readGeneratedFieldsFromNBT(tag);
        if (tag.func_150297_b("side", 3)) {
            this.side = EnumFacing.field_82609_l[tag.func_74762_e("side")];
        }
    }
}

