/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.raytracer;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.raytracer.CuboidRayTraceResult;
import com.zeitheron.hammercore.raytracer.ExtendedRayTraceResult;
import com.zeitheron.hammercore.raytracer.IndexedCuboid6;
import com.zeitheron.hammercore.utils.math.MathHelper;
import com.zeitheron.hammercore.utils.math.vec.Cuboid6;
import com.zeitheron.hammercore.utils.math.vec.Vector3;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RayTracer {
    private Vector3 vec = new Vector3();
    private Vector3 vec2 = new Vector3();
    private Vector3 s_vec = new Vector3();
    private double s_dist;
    private int s_side;
    private IndexedCuboid6 c_cuboid;
    private static ThreadLocal<RayTracer> t_inst = new ThreadLocal();

    public static RayTracer instance() {
        RayTracer inst = t_inst.get();
        if (inst == null) {
            inst = new RayTracer();
            t_inst.set(inst);
        }
        return inst;
    }

    private void traceSide(int side, Vector3 start, Vector3 end, Cuboid6 cuboid) {
        this.vec.set(start);
        Vector3 hit = null;
        switch (side) {
            case 0: {
                hit = this.vec.XZintercept(end, cuboid.min.y);
                break;
            }
            case 1: {
                hit = this.vec.XZintercept(end, cuboid.max.y);
                break;
            }
            case 2: {
                hit = this.vec.XYintercept(end, cuboid.min.z);
                break;
            }
            case 3: {
                hit = this.vec.XYintercept(end, cuboid.max.z);
                break;
            }
            case 4: {
                hit = this.vec.YZintercept(end, cuboid.min.x);
                break;
            }
            case 5: {
                hit = this.vec.YZintercept(end, cuboid.max.x);
            }
        }
        if (hit == null) {
            return;
        }
        switch (side) {
            case 0: 
            case 1: {
                if (MathHelper.between(cuboid.min.x, hit.x, cuboid.max.x) && MathHelper.between(cuboid.min.z, hit.z, cuboid.max.z)) break;
                return;
            }
            case 2: 
            case 3: {
                if (MathHelper.between(cuboid.min.x, hit.x, cuboid.max.x) && MathHelper.between(cuboid.min.y, hit.y, cuboid.max.y)) break;
                return;
            }
            case 4: 
            case 5: {
                if (MathHelper.between(cuboid.min.y, hit.y, cuboid.max.y) && MathHelper.between(cuboid.min.z, hit.z, cuboid.max.z)) break;
                return;
            }
        }
        double dist = this.vec2.set(hit).subtract(start).magSquared();
        if (dist < this.s_dist) {
            this.s_side = side;
            this.s_dist = dist;
            this.s_vec.set(this.vec);
        }
    }

    public boolean rayTraceCuboid(Vector3 start, Vector3 end, Cuboid6 cuboid) {
        this.s_dist = Double.MAX_VALUE;
        this.s_side = -1;
        for (int i = 0; i < 6; ++i) {
            this.traceSide(i, start, end, cuboid);
        }
        return this.s_side >= 0;
    }

    public IndexedCuboid6 rayTraceCuboids(Vector3 start, Vector3 end, List<IndexedCuboid6> cuboids) {
        double c_dist = Double.MAX_VALUE;
        int c_side = 0;
        Vector3 c_vec = Vector3.zero;
        IndexedCuboid6 c_hit = null;
        for (IndexedCuboid6 cuboid : cuboids) {
            if (!this.rayTraceCuboid(start, end, cuboid) || !(this.s_dist < c_dist)) continue;
            c_dist = this.s_dist;
            c_side = this.s_side;
            c_vec = this.s_vec;
            c_hit = cuboid;
        }
        if (c_hit != null) {
            this.s_dist = c_dist;
            this.s_side = c_side;
            this.s_vec = c_vec;
        }
        return c_hit;
    }

    public ExtendedRayTraceResult rayTraceCuboid(Vector3 start, Vector3 end, Cuboid6 cuboid, BlockPos pos, Object data) {
        return this.rayTraceCuboid(start, end, cuboid) && this.s_side != -1 ? new ExtendedRayTraceResult(this.s_vec, this.s_side, pos, data, this.s_dist) : null;
    }

    public ExtendedRayTraceResult rayTraceCuboid(Vector3 start, Vector3 end, Cuboid6 cuboid, Entity entity, Object data) {
        return this.rayTraceCuboid(start, end, cuboid) ? new ExtendedRayTraceResult(entity, this.s_vec, data, this.s_dist) : null;
    }

    public ExtendedRayTraceResult rayTraceCuboids(Vector3 start, Vector3 end, List<IndexedCuboid6> cuboids, BlockPos pos) {
        IndexedCuboid6 hit = this.rayTraceCuboids(start, end, cuboids);
        return hit != null && this.s_side != -1 ? new ExtendedRayTraceResult(this.s_vec, this.s_side, pos, hit.data, this.s_dist) : null;
    }

    public ExtendedRayTraceResult rayTraceCuboids(Vector3 start, Vector3 end, List<IndexedCuboid6> cuboids, Entity entity) {
        IndexedCuboid6 hit = this.rayTraceCuboids(start, end, cuboids);
        return hit != null ? new ExtendedRayTraceResult(entity, this.s_vec, hit.data, this.s_dist) : null;
    }

    public static CuboidRayTraceResult rayTraceCuboidsClosest(Vector3 start, Vector3 end, BlockPos pos, List<IndexedCuboid6> cuboids) {
        ArrayList<CuboidRayTraceResult> results = new ArrayList<CuboidRayTraceResult>();
        for (IndexedCuboid6 cuboid6 : cuboids) {
            CuboidRayTraceResult hit = RayTracer.rayTrace(pos, start, end, cuboid6);
            if (hit != null) {
                hit.setData(cuboid6.data);
            }
            results.add(hit);
        }
        CuboidRayTraceResult closestHit = null;
        double curClosest = Double.MAX_VALUE;
        for (CuboidRayTraceResult hit : results) {
            if (hit == null || !(curClosest > hit.dist)) continue;
            closestHit = hit;
            curClosest = hit.dist;
        }
        return closestHit;
    }

    public static CuboidRayTraceResult rayTrace(BlockPos pos, Vector3 start, Vector3 end, IndexedCuboid6 cuboid) {
        Vector3 posvec = new Vector3(pos);
        Vector3 startRay = start.copy().subtract(posvec);
        Vector3 endRay = end.copy().subtract(posvec);
        RayTraceResult bbResult = cuboid.aabb().func_72327_a(startRay.vec3(), endRay.vec3());
        if (bbResult != null) {
            Vector3 hitVec = new Vector3(bbResult.field_72307_f).add(posvec);
            EnumFacing sideHit = bbResult.field_178784_b;
            double dist = hitVec.copy().subtract(start).magSquared();
            return new CuboidRayTraceResult(hitVec, pos, sideHit, cuboid, dist);
        }
        return null;
    }

    public static RayTraceResult retraceBlock(World world, EntityPlayer player, BlockPos pos) {
        IBlockState b = world.func_180495_p(pos);
        Vec3d headVec = RayTracer.getCorrectedHeadVec((EntityLivingBase)player);
        Vec3d lookVec = player.func_70676_i(1.0f);
        double reach = RayTracer.getBlockReachDistance(player);
        Vec3d endVec = headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
        return b.func_185910_a(world, pos, headVec, endVec);
    }

    private static double getBlockReachDistance_server(EntityPlayerMP player) {
        return player.field_71134_c.getBlockReachDistance();
    }

    @SideOnly(value=Side.CLIENT)
    private static double getBlockReachDistance_client() {
        return HammerCore.renderProxy.getBlockReachDistance_client();
    }

    public static RayTraceResult retraceFully(EntityPlayer player) {
        return RayTracer.retraceFully(player, RayTracer.getBlockReachDistance(player));
    }

    public static RayTraceResult retrace(EntityPlayer player) {
        return RayTracer.retrace(player, RayTracer.getBlockReachDistance(player));
    }

    public static RayTraceResult retrace_stopOnLiquid(EntityPlayer player) {
        return RayTracer.retrace_stopOnLiquid(player, RayTracer.getBlockReachDistance(player));
    }

    public static Entity retraceEntity(EntityPlayer player) {
        return RayTracer.retraceEntity((EntityLivingBase)player, RayTracer.getBlockReachDistance(player));
    }

    public static RayTraceResult retraceFully(EntityPlayer player, double reach) {
        Entity entity = RayTracer.retraceEntity((EntityLivingBase)player, reach);
        RayTraceResult block = RayTracer.retrace(player, reach);
        if (entity != null && (block == null || entity.func_70068_e((Entity)player) <= player.func_174818_b(block.func_178782_a()))) {
            return new RayTraceResult(entity);
        }
        return block;
    }

    public static RayTraceResult retrace(EntityPlayer player, double reach) {
        Vec3d headVec = RayTracer.getCorrectedHeadVec((EntityLivingBase)player);
        Vec3d lookVec = player.func_70676_i(1.0f);
        Vec3d endVec = headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
        return player.field_70170_p.func_147447_a(headVec, endVec, false, true, true);
    }

    public static RayTraceResult retrace(EntityPlayer player, double reach, boolean entities) {
        Entity entityResult;
        if (entities && (entityResult = RayTracer.retraceEntity((EntityLivingBase)player, reach)) != null) {
            return new RayTraceResult(entityResult);
        }
        Vec3d headVec = RayTracer.getCorrectedHeadVec((EntityLivingBase)player);
        Vec3d lookVec = player.func_70676_i(1.0f);
        Vec3d endVec = headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
        return player.field_70170_p.func_147447_a(headVec, endVec, false, true, true);
    }

    public static RayTraceResult retrace_stopOnLiquid(EntityPlayer player, double reach) {
        Vec3d headVec = RayTracer.getCorrectedHeadVec((EntityLivingBase)player);
        Vec3d lookVec = player.func_70676_i(1.0f);
        Vec3d endVec = headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
        return player.field_70170_p.func_147447_a(headVec, endVec, true, true, true);
    }

    public static Entity retraceEntity(EntityLivingBase ent, double reach) {
        Vec3d begin = RayTracer.getStartVec(ent);
        Vec3d lookVec = ent.func_70676_i(1.0f);
        Vec3d end = begin.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
        List tracedList = ent.field_70170_p.func_175647_a(Entity.class, new AxisAlignedBB(begin.field_72450_a, begin.field_72448_b, begin.field_72449_c, end.field_72450_a, end.field_72448_b, end.field_72449_c), t -> t != ent && ent.func_70685_l(t) && t.func_70067_L() && t.func_174813_aQ().func_72327_a(begin, end) != null);
        Entity traced = null;
        for (int i = 0; i < tracedList.size(); ++i) {
            if (traced != null && !(ent.func_70068_e((Entity)tracedList.get(i)) < ent.func_70068_e(traced))) continue;
            traced = (Entity)tracedList.get(i);
        }
        return traced;
    }

    public static Vec3d getCorrectedHeadVec(EntityLivingBase entity) {
        Vector3 v = Vector3.fromEntity((Entity)entity);
        v.y += (double)entity.func_70047_e();
        return v.vec3();
    }

    public static Vec3d getStartVec(EntityLivingBase entity) {
        return RayTracer.getCorrectedHeadVec(entity);
    }

    public static double getBlockReachDistance(EntityPlayer player) {
        return player.field_70170_p.field_72995_K ? RayTracer.getBlockReachDistance_client() : (player instanceof EntityPlayerMP ? RayTracer.getBlockReachDistance_server((EntityPlayerMP)player) : 5.0);
    }

    public static Vec3d getEndVec(EntityPlayer player) {
        Vec3d headVec = RayTracer.getCorrectedHeadVec((EntityLivingBase)player);
        Vec3d lookVec = player.func_70676_i(1.0f);
        double reach = RayTracer.getBlockReachDistance(player);
        return headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
    }
}

