/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.net;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.net.HCNet;
import com.zeitheron.hammercore.net.IPacket;
import com.zeitheron.hammercore.net.PacketContext;
import com.zeitheron.hammercore.utils.base.Cast;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketHolder {
    public final IPacket packet;
    public final String playerName;
    public final UUID playerUUID;
    public final int playerId;

    public PacketHolder(NBTTagCompound nbt) {
        this.packet = HCNet.readPacket(nbt);
        this.playerName = nbt.func_74779_i("PN");
        this.playerUUID = nbt.func_186857_a("PU");
        this.playerId = nbt.func_74762_e("PI");
    }

    public PacketHolder(IPacket packet, EntityPlayer player) {
        this.packet = packet;
        if (player != null) {
            this.playerName = player.func_146103_bH().getName();
            this.playerUUID = player.func_146103_bH().getId();
            this.playerId = player.func_145782_y();
        } else {
            this.playerName = "Undefined";
            this.playerUUID = UUID.randomUUID();
            this.playerId = -1;
        }
    }

    public PacketHolder(IPacket packet) {
        this.packet = packet;
        this.playerName = "Undefined";
        this.playerUUID = UUID.randomUUID();
        this.playerId = -1;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt = HCNet.writePacket(this.packet, nbt);
        nbt.func_74778_a("PN", this.playerName);
        nbt.func_186854_a("PU", this.playerUUID);
        nbt.func_74768_a("PI", this.playerId);
        return nbt;
    }

    public boolean containsPlayer() {
        return this.playerId > 0;
    }

    public boolean enforceMainThread() {
        return this.packet != null && this.packet.executeOnMainThread();
    }

    @SideOnly(value=Side.CLIENT)
    public PacketHolder execute(FMLNetworkEvent.ClientCustomPacketEvent handler) {
        EntityPlayer player = HammerCore.renderProxy.getClientPlayer();
        PacketContext ctx = new PacketContext(new PacketContext.ContextSenderServer(player), this, null);
        this.packet.executeOnClient2(ctx);
        return new PacketHolder(ctx.getReply(), player);
    }

    public PacketHolder execute(FMLNetworkEvent.ServerCustomPacketEvent handler) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        NetHandlerPlayServer net = Cast.cast(handler.getHandler(), NetHandlerPlayServer.class);
        EntityPlayerMP mp = net != null ? net.field_147369_b : this.getPlayer(server);
        PacketContext ctx = new PacketContext(new PacketContext.ContextSenderPlayerMP(mp), this, server);
        this.packet.executeOnServer2(ctx);
        return new PacketHolder(ctx.getReply());
    }

    public EntityPlayerMP getPlayer(MinecraftServer server) {
        return server != null && this.containsPlayer() ? server.func_184103_al().func_177451_a(this.playerUUID) : null;
    }
}

