/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import gigaherz.guidebook.GuidebookMod;
import gigaherz.guidebook.client.ModelHandle;
import gigaherz.guidebook.guidebook.BookDocument;
import gigaherz.guidebook.guidebook.client.BookRegistry;
import gigaherz.guidebook.guidebook.client.BookResourceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.SelectiveReloadStateHandler;
import net.minecraftforge.common.model.IModelState;

public class BookBakedModel
implements IBakedModel {
    private static final ResourceLocation FAKE_LOCATION = GuidebookMod.location("models/block/custom/book");
    private static final ResourceLocation BASE_MODEL = GuidebookMod.location("block/book.obj");
    private final TextureAtlasSprite particle;
    private final IModelState state;

    public BookBakedModel(IModelState state, @Nullable TextureAtlasSprite particle) {
        this.state = state;
        this.particle = particle;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        return Collections.emptyList();
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particle;
    }

    @Deprecated
    public ItemCameraTransforms func_177552_f() {
        return null;
    }

    public ItemOverrideList func_188617_f() {
        return new ItemOverrideList(Collections.emptyList()){

            public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
                ResourceLocation cover;
                String book;
                BookDocument bookDocument;
                NBTTagCompound tag;
                ModelHandle mh = ModelHandle.of(BASE_MODEL);
                if (BookBakedModel.this.state != null) {
                    mh = mh.state(BookBakedModel.this.state);
                }
                if ((tag = stack.func_77978_p()) != null && (bookDocument = BookRegistry.get(new ResourceLocation(book = tag.func_74779_i("Book")))) != null && (cover = bookDocument.getCover()) != null) {
                    mh = mh.replace("#CoverGraphics", cover.toString());
                }
                return mh.get();
            }
        };
    }

    public static class ModelLoader
    implements ICustomModelLoader {
        public boolean accepts(ResourceLocation modelLocation) {
            return FAKE_LOCATION.equals((Object)modelLocation);
        }

        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            return new Model();
        }

        public void func_110549_a(IResourceManager resourceManager) {
            this.onResourceManagerReload(resourceManager, SelectiveReloadStateHandler.INSTANCE.get());
        }

        public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
            if (resourcePredicate.test(BookResourceType.INSTANCE)) {
                BookRegistry.parseAllBooks(resourceManager);
            }
        }
    }

    private static class Model
    implements IModel {
        @Nullable
        private final ResourceLocation particle;

        Model() {
            this.particle = null;
        }

        Model(@Nullable String particle) {
            this.particle = particle == null ? null : new ResourceLocation(particle);
        }

        public Collection<ResourceLocation> getDependencies() {
            ArrayList dependencies = Lists.newArrayList();
            dependencies.add(BASE_MODEL);
            return dependencies;
        }

        public Collection<ResourceLocation> getTextures() {
            HashSet textures = Sets.newHashSet();
            if (this.particle != null) {
                textures.add(this.particle);
            }
            for (BookDocument renderer : BookRegistry.getLoadedBooks().values()) {
                renderer.findTextures(textures);
            }
            return textures;
        }

        public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            TextureAtlasSprite part = null;
            if (this.particle != null) {
                part = bakedTextureGetter.apply(this.particle);
            }
            return new BookBakedModel(state, part);
        }

        public IModelState getDefaultState() {
            return part -> Optional.empty();
        }

        public IModel retexture(ImmutableMap<String, String> textures) {
            return new Model((String)textures.get((Object)"particle"));
        }
    }
}

