/*
 * Decompiled with CFR 0.152.
 */
package extracells.item.storage;

import appeng.api.implementations.items.IStorageComponent;
import extracells.integration.Integration;
import extracells.item.ItemECBase;
import extracells.item.storage.CellDefinition;
import extracells.item.storage.StorageType;
import extracells.models.ModelManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemStorageComponent
extends ItemECBase
implements IStorageComponent {
    public ItemStorageComponent() {
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public int getBytes(ItemStack itemStack) {
        StorageType type = CellDefinition.components.fromMeta(itemStack.func_77952_i());
        return type.getBytes();
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        StorageType type = CellDefinition.components.fromMeta(itemStack.func_77952_i());
        CellDefinition definition = type.getDefinition();
        return definition.getRarity();
    }

    public void func_150895_a(CreativeTabs creativeTab, NonNullList itemList) {
        if (!this.func_194125_a(creativeTab)) {
            return;
        }
        for (StorageType type : CellDefinition.components) {
            if (type.getDefinition() == CellDefinition.GAS && !Integration.Mods.MEKANISMGAS.isEnabled()) continue;
            itemList.add((Object)new ItemStack((Item)this, 1, type.getMeta()));
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        StorageType type = CellDefinition.components.fromMeta(itemStack.func_77952_i());
        return "extracells.item.storage.component." + type.getIdentifier();
    }

    public boolean isStorageComponent(ItemStack itemStack) {
        return itemStack.func_77973_b() == this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, ModelManager manager) {
        for (StorageType type : CellDefinition.components) {
            if (type.getDefinition() == CellDefinition.GAS && !Integration.Mods.MEKANISMGAS.isEnabled()) continue;
            manager.registerItemModel(item, type.getMeta(), type.getModelName());
        }
    }
}

